function h = meshelem(elems,u,ifig,lab,lw)
%
% h = meshelem(elems,u,ifig,'lab',lw);
%
% Given structures elems & u (e.g., from gbin_input),
% create a mesh plot in figure ifig (default 1), of variable
% labled 'u.lab' (default 'u.V1').
% Return graphics objects handle structure h.
% h.surf contains a patch-object handle, h.text is a
% element-no. text-handle vector, and h.edge(1:4) are element-edge handles,
% to lines of width lw (default 3).
% Enter set(h.text,'Visible','on') etc. to make objects visible.
%
if nargin<3
   ifig=1;
end
if nargin<4
   lab='V1'
end
if nargin<5
   lw=3;
end
figure(ifig)				% set current figure window
cla					% clear figure
hold on					% don't overwrite objects
%___Get polynomial sizes (assumed constant):
m=eval(['size(u.' lab '{1})']);		% m(1) by m(2) nodes for element 1
j=zeros(elems.n,1);			% allocate element node set pointer
%___allocate surf array storage:
[x y z]=deal(zeros((m(1)+1)*elems.n,m(2)));
ir=1;					% initialize row index
rs=0:m(1);				% row span
skip=nan(1,m(2));			% skipped row
for i=1:elems.n				% loop over elements:
   j(i)=eval(['u.' lab 'ic(i)']);	% assign element node set pointer
   x(ir+rs,:)=[elems.x{j(i)}(:,:,1)
               skip];
   y(ir+rs,:)=[elems.x{j(i)}(:,:,2)
               skip];
   z(ir+rs,:)=[eval(['u.' lab '{i}'])
               skip];
   ir=ir+m(1)+1;			% increment row index
end
h.surf=surf(x,y,z);
colormap(rwbmap(64))			% nice color map
%daspect(daspect*[.5 .5 0;.5 .5 0;0 0 1])% set data aspect ratio
grid on
view(3)					% default 3D view
xlabel('{\itx}_1')
ylabel('{\itx}_2')
zlabel(lab)
[x y z]=deal(zeros((m(1)+1)*elems.n,1));% allocate line array storage
ir=1;					% initialize row index
for i=1:elems.n				% loop over elements:
   x(ir+rs)=[elems.x{j(i)}(:,1,1)
             NaN];
   y(ir+rs)=[elems.x{j(i)}(:,1,2)
             NaN];
   z(ir+rs)=[eval(['u.' lab '{i}(:,1)'])
             NaN];
   ir=ir+m(1)+1;			% increment row index
end
h.edge(1)=line(x,y,z,'Color','y','LineWidth',lw);
ir=1;					% initialize row index
for i=1:elems.n				% loop over elements:
   x(ir+rs)=[elems.x{j(i)}(:,m(2),1)
             NaN];
   y(ir+rs)=[elems.x{j(i)}(:,m(2),2)
             NaN];
   z(ir+rs)=[eval(['u.' lab '{i}(:,m(2))'])
             NaN];
   ir=ir+m(1)+1;			% increment row index
end
h.edge(3)=line(x,y,z,'Color','y','LineWidth',lw);
[x y z]=deal(zeros(1,(m(2)+1)*elems.n));% allocate line array storage
rs=0:m(2);				% row span
ir=1;					% initialize row index
for i=1:elems.n				% loop over elements:
   x(ir+rs)=[elems.x{j(i)}(m(1),:,1) NaN];
   y(ir+rs)=[elems.x{j(i)}(m(1),:,2) NaN];
   z(ir+rs)=[eval(['u.' lab '{i}(m(1),:)']) NaN];
   ir=ir+m(2)+1;			% increment row index
end
h.edge(2)=line(x,y,z,'Color','y','LineWidth',lw);
ir=1;					% initialize row index
for i=1:elems.n				% loop over elements:
   x(ir+rs)=[elems.x{j(i)}(1,:,1) NaN];
   y(ir+rs)=[elems.x{j(i)}(1,:,2) NaN];
   z(ir+rs)=[eval(['u.' lab '{i}(1,:)']) NaN];
   ir=ir+m(2)+1;			% increment row index
end
h.edge(4)=line(x,y,z,'Color','y','LineWidth',lw);
[x y z]=deal(zeros(elems.n,1));		% allocate text array storage
for i=1:elems.n				% loop over elements:
   x(i)=mean(mean(elems.x{j(i)}(:,:,1)));
   y(i)=mean(mean(elems.x{j(i)}(:,:,2)));
   z(i)=max(max(eval(['u.' lab '{i}'])));
   t{i}=int2str(i-1);
end
h.text=text(x,y,z,t,'FontSize',20,'Color','y', ...
   'HorizontalAlignment','center','VerticalAlignment','middle');
set(h.text,'Visible','off')
