function ui=ntrpelem(a,b,c,d,e,method)
%
% zi=ntrpelem(elems,u,'lab',   xi,         yi,'method')
% ui=ntrpelem(    x,y,    z,'lab',{elemsi ic},'method')
%
% Interpolate from values u.lab on elems.x to zi on xi & yi, or
% from values z on x & y to ui.lab on elemsi.x{ic}, using
% 'method' (default 'linear', accepts 'cubic', 'nearest', 'spline').
% Pass xi & yi as vectors or matrices as in INTERP2.
% The default ic is 1:elemsi.n but for staggered grids ic
% should be specified, e.g., u.V1ic, u.Pic etc.
%
if nargin<6
   method='linear';
end
if isstruct(a)			% interpolate _from_ elements
   [elems,u,lab,xi,yi]=deal(a,b,c,d,e);
   clear a b c d e
   K=elems.n;			% no. elements
   ic=eval(['u.' lab 'ic']);	% indexes to coordinates
   N=size(elems.x{ic(1)},1);	% no. polynomials per dimension-element
   if length(xi)==prod(size(xi))% assume xi & yi are vectors
      [xi yi]=ndgrid(xi,yi);
   end
   ui=zeros(size(xi));
   b=0;
   for k=1:K			% element loop
      b=overWrite(b,sprintf('ntrpelem: element %d of $d',k,K));
      j=ic(k);			% index to coordinates
      x=elems.x{j}(:,1,1);	% assume locally Cartesian
      y=elems.x{j}(1,:,2)';
      z=eval(['u.' lab '{k}']);
      p=find(min(x)<=xi&xi<=max(x)&min(y)<=yi&yi<=max(y));
%_____zi can be accelerated FIXME
%_____LagrInte should use Legendre polynomials FIXME
      zi=diag(LagrInte(xi(p),x)*z*LagrInte(yi(p),y)');
      a=.5*(ui(p)~=0);		% was any ui assigned previously?
      ui(p)=a.*ui(p)+(1-a).*zi;	% average previous assignments
   end
else				% interpolate _to_ elements
   if length(e)<2
      e={e{1} 1:e{1}.n};
   end
   [x,y,z,lab,elemsi,ic]=deal(a,b,c,d,e{:});
   clear a b c d e
   K=elemsi.n;			% no. elements
   b=0;
   for k=1:K			% element loop
      j=ic(k);			% index to coordinates
      xi=elemsi.x{j}(:,:,1);
      yi=elemsi.x{j}(:,:,2);
      eval(['ui.' lab '{k}=interp2(x,y,z,xi,yi,method);'])
      eval(['ui.' lab 'ic(k)=j;'])
      b=overWrite(b,sprintf('ntrpelem: %d of %d',k,K));
   end
end
