function z = onewave(x,y,k,t,expr)
%
% function u=onewave(x,y,k,t,expr);
% function u=onewave(elems,V,k,t,expr);
%
% Return the one-wave solution u on [0,1]^2 of
%
% u_t + (ds/dt).grad u = nu div grad u,
%
% u = exp(-nu*K*K'*t)*sin(K*(r-R-s(t))'),
%
% where
%
% nu = k(5), K = k([2 4]), r = [x y], R = k([1 3]),
% k(1) in [0,1] is x-phase R(1) (default 0),
% k(2) in 2pi*integers is x-wavenumber K(1) (default 2pi),
% k(3) in [0,1] is y-phase R(2) (default 0),
% k(4) in 2pi*integers is y-wavenumber K(2) (default 0),
% k(5) is the diffusivity nu (default 1e-2), and
% expr is a string (default '[t 0]') giving s(t).
%
% If (x,y) are passed they're assumed to have uniform meshgrid-type shapes.
% If (elems,V) are passed they correspond to typical elems structure and u.V1 field,
% and u has fields u.Va, u.Vaic, u.Verr=V-u.Va and u.Verric.
%
if nargin<3|isempty(k)
   k=[0 2*pi 0 0 1e-2];			% parameters
end
if nargin<4
   t=0;					% initial condition
end
if nargin<5
   expr='[t 0]';
end
R=k([1 3])+eval(expr);			% 2D phase
K=k([2 4]);				% 2D wavenumber
nu=k(5);				% diffusivity
if isstruct(x)				% x is the structure elems
   flag=1;
   nelem=x.n;				% no. elements
   x=x.x;
else
   flag=0;
   nelem=1;
   x={cat(3,x,y)};
end
for i=1:nelem				% loop over number elements
   z=exp(-nu*K*K'*t).*sin(K(1)*(x{i}(:,:,1)-R(1))+K(2)*(x{i}(:,:,2)-R(2)));
   if flag
      u.Va{i}=z;
      u.Vaic(i)=i;
      u.Verr{i}=u.Va{i}-y{i};
      u.Verric(i)=i;
   end
end
if flag
   z=u;
end
