function b = overWrite(b, n)
%  b = overWrite(b, n)
%
%  Backup b characters (the number of characters in the
%  string printed by the last call to {\tt overWrite})
%  and print the new string, returning its length in {\tt b}.
%
%  Inputs
%
%    b      number of characters used in last overWrite
%    n      string or integer
%
%  Outputs
%
%    b      number of characters used in this overWrite
%
%  Downloaded 2005/8/17 from
%  http://www.lce.hut.fi/teaching/S-114.200/matlab/rbf/Utilities/

% backup
for i = 1:b
  fprintf('\b');
end

if nargin < 2

  % rub out
  s = ' ';
  fprintf('%s', s(ones(1,b)))

  % backup again
  for i = 1:b
    fprintf('\b');
  end

else

  % print
  if ischar(n)
    fprintf('%s', n)
    b = length(n);
  else
    s = sprintf('%d', n);
    fprintf('%s', s);
    b = length(s);
  end

end
