function z = perGauss(x,y,k,t,expr)
%
% function w=perGauss(x,y,k,t,expr);
% function w=perGauss(elems,u,k,t,expr);
%
% w = periodized Gaussians in both directions:
%
%             oo  oo                   2              2
% w(0,x,y) = sum sum exp(-((x-i-k1)/k2) -((y-j-k3)/k4) )
%            -oo -oo
%
%                  oo            2                    2
%          = (1+2*sum exp(-(i/k2) )*cosh(2*(x-k1)*i/k2 ))
%                 i=1
%
%                  oo            2                    2                   2            2
%          * (1+2*sum exp(-(j/k4) )*cosh(2*(y-k3)*j/k4 ))*exp(-((x-k1)/k2) -((y-k3)/k4) ).
%                 j=1
%
% If (x,y) are passed they're assumed to have uniform meshgrid-type shapes.
% If (elems,u) are passed they correspond to typical elems and u structures,
% and w has fields w.Va, w.Vaic (and if u.V1~=[]) w.Verr=w.Va-u.V1 and w.Verric.
%
% k(1) in [0,1] is the x-location of the peak (default .5),
% k(2) in ]0,1] is x-width (default .1),
% k(3) in [0,1] is the y-location of the peak (default .5),
% k(4) in ]0,1] is y-width (default .1),
% k(5) is the diffusivity nu (default 1e-3) if t>0.
%
% If t>0 then return solution from t=0 i.c. of
%
% w  = (nu div grad - c(t).grad)w
%  t
%
% where c(t)=dr/dt and r(t) is given by the string
% expr (default '.25*[sin(t),-cos(t)]').
% If t=0 expr still modifies the (k1,k3) location.
% 
if nargin<3|isempty(k)
   k=[.5 .1 .5 .1 1e-3];
end
if nargin<4|isempty(t)
   t=0;				% initial condition
end
if nargin<5
   expr='.25*[sin(t),-cos(t)]';
end
k([1 3])=k([1 3])+eval(expr);
if isstruct(x)			% x is the structure elems
   flag=1;
   jass='y.V1ic(i)';		% j assignment
   nelem=x.n;			% no. elements
   x=x.x;
else				% x & y are meshgrid-style
   flag=0;
   jass='i';			% j assignment
   nelem=1;			% one element
   x={cat(3,x,y)};		% imitate element structure
end
for i=1:nelem			% loop over number elements
   j=eval(jass);		% j assignment
   p{1}=x{j}(:,:,1)-k(1);	% shift x by k1
   p{2}=x{j}(:,:,2)-k(3);	% shift y by k3
   o=ones(size(p{1}));		% assume correct x size
   z=o;
   if t==0			% initial condition
      for l=1:2			% loop over spatial directions
         b=exp(-1/k(2*l)^2);
         c=b^2;
         w=o;
         a=Inf;			% initial accuracy tolerance
         n=1;			% centering point
         q=2*p{l}/k(2*l)^2;	% cosh argument factor
         r=b;			% exp(-n^2/k^2)
         s=c;			% exp(-2*n/k^2)
         while a>eps*max(abs(w(:)))
            dz=2*r*cosh(n*q);
            w=w+dz;
            a=max(abs(dz(:)));	% accuracy tolerance
            r=r*s*b;		% exp(-n^2/k^2)
            s=s*c;		% exp(-2*n/k^2)
            n=n+1;		% centering point
         end
         z=z.*w.*b.^(p{l}.^2);	% mult. factor for this l
%        nit(l)=n-1;		% no. iterations
      end
%     disp(sprintf('Element %d max shift: (%d,%d)',i-1,nit))
   else
      z=GaPoisum(k([2 4]),p,k(5),t);
   end
   z(find(isnan(z(:))))=0;		% eliminate NaN values
   if flag
      u.Va{i}=z(:,:,1);
      u.Vaic(i)=eval(jass);
   end
end
if flag&~isempty(y.V1)
   for i=1:nelem			% loop over number elements
      u.Verr{i}=u.Va{i}-y.V1{i};	% error field
      u.Verric(i)=eval(jass);
   end
end
if flag
   z=u;
end
