function z1 = planarNWave(x,y1,c,t)
%
% function u=planarNWave(x,y,c,t);
% function u=planarNWave(elems,V,c,t);
%
% u = planar NWave solution in x-directions:
%
%             oo  oo                                   
% u(t,x,y) = sum sum x/t [1+sqrt(t/c(3)) *[exp[((x-c(1)))^2/(4 c(4) t) ] / g(R0) ] ^-1
%            -oo -oo
%
% where 
%             g(R0) = exp(R0) - 1.
%
% If (x,y) are passed they're assumed to have uniform meshgrid-type shapes.
% If (elems,V) are passed they correspond to typical elems structure and u.V1 field,
% and u has fields u.Va, u.Vaic, u.Verr=u.Va-V and u.Verric.
%
% c(1) in [0,1] is the x-location of the peak (default .5),
% c(2) in [0,1] is the y-location of the peak (default .5),
% c(3) is the diffusivity nu (default 1e-3) if t>0.
% c(4) is the A-parameter  (default 1).
%
% If t>t0 then return solution from t=t0 i.c. of
%
% u  = (nu div grad - u.grad)u
%
% Calling example:
%   u1=planarNWave(elem,u.V1,[.5 .5 1 nu 100],t);

% 


eps = 1e-18;
if nargin<4|isempty(c)
   c=[.5 .5 1e-4 1];
end
if nargin<4
   t=c(3);				% initial condition
end
%c([1 3])=k([1 3])+eval(expr);
if isstruct(x)			% x is the structure elems
   flag=1;
   nelem=x.n;			% no. elements
   x=x.x;
else				% x & y are meshgrid-style
   flag=0;
   nelem=1;			% one element
   x={cat(3,x,y1)};		% imitate element structure
end
t
c
%t0     = c(3);
%R0     = c(5);
nufact = 1.0/( 4*c(3)*t );
%rfact  = 1.0 / ( exp(R0) - 1);
%tfact  = sqrt(t/t0);
k      = [2*pi 2*pi];
for i=1:nelem			% loop over number elements
   p{1}=x{i}(:,:,1)-c(1);	% shift x by x0
   p{2}=x{i}(:,:,2)-c(2);	% shift y by y0 
   zer=zeros(size(p{1}));		% assume correct x size
   one =ones(size(p{1}));		% assume correct x size
   xpp = p{1};
%  argp    = (xpp.^2) .* nufact;    
%  gfactp  = 1.0./( t .* ( 1.0 + ( (tfact*rfact) .* exp(argp) ) ) );  
   efact   = exp(-xpp.^2 .* nufact) .* sqrt(c(4)/t); 
   gfactp  = efact ./ ( t .* ( 1.0 + efact ) ); 
   z1    = gfactp .* xpp;

%  disp(sprintf('Element %d max shift: (%d,%d)',i-1,nit))
   z1(find(isnan(z1(:))))=0;		% eliminate NaN values
   if flag
      u1.Va{i}=z1(:,:,1);
      u1.Vaic(i)=i;
      u1.Verr{i}=u1.Va{i}-y1{i};		% error field
      u1.Verric(i)=i;
   end
end
if flag
   z1=u1;
end
