function m=rwbmap(n,c)
%
% m=rwbmap(n);
% m=rwbmap(n,c);
%
% Red, white and blue map of n colors.
% If c(1:3) is passed then the colors are registered
% to the 3 values c([3 2 1]), assumed decreasing.
%
if nargin<2
   x=1:3;
   xi=linspace(1,3,n);
else
   x=c;
   k=floor(n*(c(2)-c(1))/(c(3)-c(1)));
   xi=[linspace(c(1),c(2),k) linspace(c(2),c(3),n-k)];
end
m=interp1(x,[0 0 1
             1 1 1
             1 0 0],xi);
