owd=pwd;				% old (current) working directory
cd ~/sem/gaspar2d/test/
ne=8;					% no. elements per edge
np=3:2:11;				% polynomial-space sizes
%C=[1.0 0.5 0.25 0.125 0.0625 0.03125 0.015625];
%dt=[5e-3 1.25e-3 3.125e-4 7.8125e-5 1.953125e-5 4.88e-6 1.221e-6 3.05e-7];
%no=length(C);
%np=14*ones(1,no);			% polynomial-space sizes
%xi = GausLoba(np(1)-1);
%dxmin = ( xi(2) - xi(1) ) / ( 2*ne );
%dt    = dxmin ./ C;
no=length(np);				% no. degrees to test
dt=1e-5*ones(1,no);
%dt=1e-4;				% OK timestep for np=9;
%dt=dt*(8./(np-1)).^2;			% scaled time steps
%dt=0.1./(np-1).^2;
xp=[.5 .5];				% 2D location parameter
sigma=.4/(2*pi);			% width parameter
rexpr='[t 0]';				% expression for r(t) where dr/dt advects
if ~exist('status','var')
system(sprintf('\\rm -f galump0_%dx%d_conv_n*.??????',ne,ne));
disp('Performing experiments...')
for n=1:no				% loop over degrees:
%  meshdesc=sprintf('_%dx%d_n%d',ne,ne,np(n));
%  descapp =sprintf('%s_%d', meshdesc, n);
%  ofname{n}=['galump0' descapp];	% append mesh description
   ofname{n}= sprintf('galump0_%dx%d_conv_n%d',ne,ne,np(n));
   meshfile = sprintf('./data/cone_mesh_%dx%d_n%d',ne,ne,np(n));
   s=system(sprintf('\\rm -f %s',ofname{n}));
%  cmd='./gaspar -bdf 2 -time 0.1 -linadvect -noadapt -noadvect -noupc -nu 0 -otd 0.1 -uiter 512 -utol 1e-10 ';
   cmd='./gaspar -bdf 1 -time 1e-1 -linadvect -noadapt -nu 1e-5 -otd 1e-1 ';
   cmd=sprintf('%s-dt %d ',cmd,dt(n));	% append time step
   cmd=sprintf('%s-lf log.%s ',cmd,ofname{n});
   cmd=sprintf('%s-m ',cmd,meshfile);
   cmd=sprintf('%s-of %s',cmd,ofname{n});
   tic					% start stopwatch, stop at toc
   [status(n) result{n}] = system(cmd);
   wct(n)=toc;				% wall clock time
   disp(sprintf('Returned status %d for degree %d',status(n),np(n)-1))
   if status(n)				% then error condition:
      return
   end
end
end
if ~exist('u','var')
disp('Inputting results...')
for n=1:no				% loop over degrees:
   [fileinfo(n,1) elems(n,1) u(n,1)]=gbin_input([ofname{n} '.000000']);
   d=dir([ofname{n} '.*']);		% get all output files for this degree
   mc=-Inf;				% initialize max cycle
   for l=1:length(d)			% loop over output files:
      mc=max([mc eval(d(l).name((-5:0)+end))]);
   end
   mc=sprintf('%s.%06d',ofname{n},mc);	% file with max cycle
   disp(sprintf('Inputting %s for degree %d',mc,np(n)-1))
   [fileinfo(n,2) elems(n,2) u(n,2)]=gbin_input(mc);
end
end
nu=fileinfo(1,1).fmeta(23)		% diffusivity
pars=[xp(1) sigma xp(2) sigma nu];
%flist=1:2;				% list of files
flist=2;				% list of files
for m=flist				% loop over time:
for n=1:no				% loop over degrees:
   t(n,m)=fileinfo(n,m).fmeta(11);	% current time
%  h = meshelem(elems(n,m),u(n,m),no*m+n,'V1');
%  title(sprintf('Field at time %d',t(n,m)))
   ut(n,m)=perGauss(elems(n,m),[],pars,t(n,m),rexpr);
   ue(n,m)=biopelem(ut(n,m),u(n,m),'minus','Va','V1');
   h = meshelem(elems(n,m),ue(n,m),no*(m-flist(1))+n,'VaminusV1');
   title(sprintf('Degree-%d error field at time %d',np(n)-1,t(n,m)))
end
end
for n=1:no				% loop over degrees
   uenorm(1:2,n)=statelem(elems(n,2),ue(n,2),'VaminusV1')';
   r=statelem(elems(n,2),ut(n,2),'Va');
   uenorm(2,n)=uenorm(2,n)/r(2);
end
figure(max(100,no*(flist(end)-flist(1)+1)+1))
semilogy(np-1,uenorm,'x-')
%semilogy(dt,uenorm,'x-')
ylabel('relative l2 and absolute max-abs errors')
xlabel('degree')
grid on
orient tall
