function [xel,xl,xg,Q]=simple0
%
% simple test case
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global ngdof zc
%
% first plot elements:
%
% xel(1,n,k) is the nth coordinate of the southwest vertex of the kth element, and
% xel(2,n,k) is the nth coordinate of the northeast vertex of the kth element:
%
xel=cat(3,[0 0;.5 1],[.5 0;.75 .5],[.75 0;1 .5],[.75 .5;1 1],[.5 .5;.75 1]);
nelem=size(xel,3);		% no. elements
nldof=4*nelem;			% no. local degrees of freedom
xi=[-1 1];			% Gauss-Lobatto nodes of indexes j=0,1
xl=zeros(2,4,nelem);		% local node allocation
for ielem=1:nelem		% element loop:
   k=1;				% vertex index
   for jy=1:2			% south-north loop:
      for jx=1:2		% west-east loop:
          xl(:,k,ielem) = [xel(jx,1,ielem) xel(jy,2,ielem)];
          k = k+1;
      end
   end
end
xg=xl(:,1,1)';			% global node
for ielem=1:nelem		% element loop:
   k=1;				% vertex index
   for jy=1:2			% south-north loop:
      for jx=1:2		% west-east loop:
         if ~ismember(xl(:,k,ielem)',[xg;.5 .5],'rows')
            xg = [xg
                  xl(:,k,ielem)'];
         end                                                                       
         k = k+1;
      end
   end
end
xg = xg';
ngdof=size(xg,2);		% no. global degrees of freedom
L=max(xel(:))-min(xel(:));	% length scale
ibdy=[1 1;2 1;2 2;1 2;1 1];	% closed-boundary indexes
dx=[1 -1]*L/50;			% vertex displacements
hoal={'left' 'right'};		% vertex labels HorizontalAlignment
veal={'bottom' 'top'};		% vertex labels VerticalAlignment
figure(1)
plot3(xel(ibdy(:,1),1,1),xel(ibdy(:,2),2,1),ones(5,1))
for ielem=2:nelem		% element loop for boundaries:
   line(xel(ibdy(:,1),1,ielem),xel(ibdy(:,2),2,ielem),ones(5,1));
end
for ielem=1:nelem		% element loop for index labels:
   text(mean(xel(:,1,ielem)),mean(xel(:,2,ielem)),1, ...
      ['\Omega_' int2str(ielem-1)], ...
      'HorizontalAlignment','center','VerticalAlignment','middle')
   for jy=1:2			% south-north loop:
      for jx=1:2		% west-east loop:
         text(xel(jx,1,ielem)+dx(jx),xel(jy,2,ielem)+dx(jy),1, ...
         int2str(jx+jy*2+ielem*4-7), ...
         'HorizontalAlignment',hoal{jx},'VerticalAlignment',veal{jy})
      end
   end
end
for q=1:ngdof
   text(xg(1,q),xg(2,q),1,int2str(q-1),'BackgroundColor','r','Color','y', ...
      'HorizontalAlignment','center','VerticalAlignment','middle')
end
axis([min(min(xel(:,1,:)))+dx(2) max(max(xel(:,1,:)))+dx(1) ...
      min(min(xel(:,2,:)))+dx(2) max(max(xel(:,2,:)))+dx(1)])
disp('Verify elements and keep hitting return to continue')
pause				% hit any key to continue
%
% check by plotting philocal on every local node:
%
x=linspace(min(min(xel(:,1,:))),max(max(xel(:,1,:))),65) ;
y=linspace(min(min(xel(:,2,:))),max(max(xel(:,2,:))),65)';
zc=0:.2:1;			% contour levels
caxis([0 1])			% plot's color axis
colormap(flipud(rwbmap(length(zc)-1)))
hold on
view(10,80)
%%plotphilocal(x,y,xi,xel)
%
% a priori global quantities:
%
%ieq=[0 0 0 0 1 1 2 2 3 4]+1;	% element indexes
%ijx=[0 1 0 1 1 1 1 1 1 1];	% node x-indexes
%ijy=[0 0 1 1 0 1 0 1 1 1];	% node y-indexes
plotphiglobal(x,y,xi,xel)
%
% construct scatter matrix Q:
%
for q=1:ngdof			% global d.o.f. loop:
   i = 1;			% concatenated local index
   for ielem=1:nelem		% element loop:
      k = 1;			% vertex index
      for jy=1:2		% south-north loop:
         for jx=1:2		% west-east loop:
            Q(i,q)=phiglobal(xl(1,k,ielem),xl(2,k,ielem),q-1,xi,xel);
%           if Q(i,q)~=0,disp(sprintf('Q[%d,%d]=p[%d](%4.2f,%4.2f)=%8.1e', ...
%                 i-1,q-1,q-1,xl(1,k,ielem),xl(2,k,ielem),Q(i,q))),end
            i = i+1;
            k = k+1;
         end
      end
   end
end

S=Q*Q';				% DSS matrix
u=S*(rand(nldof,5)-.5);		% random columns in ran(S)
(S*u)./u
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% construct bilinear mappings as functions:
%
function t=bilimapf(x,xel)	% forward mapping from [-1,1]^2 to element xel
o=ones(2,size(x,2));
t=xel(o(1,:),:)'+diag(xel(2,:)-xel(1,:))*(x+o)/2;
%
function x=bilimapi(t,xel)	% inverse mapping from element xel to [-1,1]^2
o=ones(2,size(t,2));
x=diag(xel(2,:)-xel(1,:))\(2*(t-xel(o(1,:),:)'))-o;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function b=inelem(x,y,xel)	% "in element" Boolean, 1 if (x,y) is in element xel
b=double(xel(1,2)<=y&y<=xel(2,2))*double(xel(1,1)<=x&x<=xel(2,1));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 1D basis function of index j=0,1 on [-1,1]:
%
function p=phi1D(x,j,xi)	% 1D basis function of index j=0,1
i=2-j;				% map [0 1] to [2 1]
p=(x-xi(i))/(xi(1+j)-xi(i));	% linear interpolant
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 2D basis functions of indexes j=0,1 on [-1,1]^2:
%
function p=phi2D(x,j,xi)
p=phi1D(x(2,:)',j(2),xi) * phi1D(x(1,:),j(1),xi);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% construct global basis functions --ad hoc at present
% (only q==1 and 3 involve interpolation with values 0,1/2,1 along interface):
%
function p=phiglobal(x,y,q,xi,xel)
n=ones(1,size(x,2));
o=ones(size(y,1),1);
if q==0
   p=    philocal(x,y,[0 0],xi,xel(:,:,1));
elseif q==1
   p=max(philocal(x,y,[1 0],xi,xel(:,:,1)),   ...
     max(philocal(x,y,[0 0],xi,xel(:,:,2))  + ...
         philocal(x,y,[0 1],xi,xel(:,:,2))/2, ...
         philocal(x,y,[0 0],xi,xel(:,:,5))/2));
elseif q==2
   p=    philocal(x,y,[0 1],xi,xel(:,:,1));
elseif q==3
   p=max(philocal(x,y,[1 1],xi,xel(:,:,1)),   ...
     max(philocal(x,y,[0 1],xi,xel(:,:,5))  + ...
         philocal(x,y,[0 0],xi,xel(:,:,5))/2, ...
         philocal(x,y,[0 1],xi,xel(:,:,2))/2));
elseif q==4
   p=max(philocal(x,y,[1 0],xi,xel(:,:,2)), ...
         philocal(x,y,[0 0],xi,xel(:,:,3)));
elseif q==5
   p=max(philocal(x,y,[1 1],xi,xel(:,:,2)), ...
     max(philocal(x,y,[0 1],xi,xel(:,:,3)), ...
     max(philocal(x,y,[0 0],xi,xel(:,:,4)), ...
         philocal(x,y,[1 0],xi,xel(:,:,5)))));
elseif q==6
   p=    philocal(x,y,[1 0],xi,xel(:,:,3));
elseif q==7
   p=max(philocal(x,y,[1 1],xi,xel(:,:,3)), ...
         philocal(x,y,[1 0],xi,xel(:,:,4)));
elseif q==8
   p=max(philocal(x,y,[0 1],xi,xel(:,:,4)), ...
         philocal(x,y,[1 1],xi,xel(:,:,5)));
elseif q==9
   p=    philocal(x,y,[1 1],xi,xel(:,:,4));
else
   error(sprintf('q==%d not defined',q))
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% local basis function in global coordinates:
%
function p=philocal(x,y,j,xi,xel)
p=inelem(x,y,xel).*phi2D(bilimapi([x;y'],xel),j,xi);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% plot global basis functions:
%
function plotphiglobal(x,y,xi,xel)
global ngdof zc
for q=0:ngdof-1			% loop over global nodes (true d.o.f.)
   z = phiglobal(x,y,q,xi,xel);
   disp(sprintf('Global basis function %8.1e<=p[%d]<=%8.1e',min(z(:)),q,max(z(:))))
%  [c h]=contourf(x,y,z,zc);
   h=meshc(x,y,z);
   hc=colorbar;
   pause
   delete(h)
end
delete(hc)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function plotphilocal(x,y,xi,xel)
global zc
nelem=size(xel,3);
for ielem=1:nelem		% loop over elements
   for jy=0:1			% loop over y-vertices
      for jx=0:1		% loop over x-vertices
         disp(sprintf('Local basis function (%d,%d) in element %d',jx,jy,ielem))
%        [c h]=contourf(x,y,philocal(x,y,[jx jy],xi,xel(:,:,ielem)),zc);
         h=meshc(x,y,philocal(x,y,[jx jy],xi,xel(:,:,ielem)));
         hc=colorbar;
         pause
         delete(h)
      end
   end
end
