function h = slicelem(elems,u,ifig,lab,sliceid,lw)
%
% h = slicelem(    elems,     u,ifig,'lab',[val dim],lw);
% h = slicelem('filepat','expr',ifig,'lab',[val dim],lw);
%
% Given structures elems & u (e.g., from gbin_input),
% create a 1D plot in figure ifig, of variable
% labeled 'lab'; return graphics objects handles h(1:K,1:N).
% h(k,n).line contains patch-object handles
% to lines of width lw (default 1) and h(k,n).text are
% element-no. handles (default, visible off).
% Use [val dim] (default [0 2]) to plot the slice in K elements
% along x=val or y=val if dim = 1 or 2 respectively.
% If the 1st argument is a string then plot curves for elems and u
% from N files identified by that string --see manycall.m;
% then 'expr' (if not []) can be a matching regular expression like
% '..2...' for all cycles 1999<n<3000 or '..2..[13579]' to exclude
% the even ones etc.
%
if ischar(elems)
   filepat=elems;
   d=dir(filepat);			% get output filenames
   lt=length(d);			% length of time list
   if ~isempty(u)
      r=regexp({d.name},u);		% lt-vector of matching indexes
      j=0;				% index offset
      for k=1:lt			% loop over files:
         if isempty(r{k})
            d(k-j)=[];			% delete k'th file
            j=j+1;			% index offset
         end
      end
      lt=length(d);			% length of time list
   end
   r=max(strfind(filepat,'/'));		% isolate directory path
   cmd='[fileinfo elems u]=gbin_input([filepat(1:r) d(k).name]);';
   msg='b=overWrite(b,sprintf(''slicelem found %d elements in %s, file %d of %d'',elems.n,d(k).name,k,lt));';
else
   lt=1;				% just one time
   cmd='';				% data already passed
   msg='';
end
if nargin<5
   sliceid=[0 2];
end
if nargin<6
   lw=1;
end
figure(ifig)				% set current figure window
%clf					% clear figure
hold on					% don't overwrite objects
l=1;
b=0;					% initialize overWrite
if sliceid(2)==1			% slice for x=sliceid(1):
   for k=1:lt				% loop over files:
      eval(cmd)				% input data unless lt==1
      eval(msg)				% display message
      for i=1:elems.n			% loop over elements:
         j = eval(['u.' lab 'ic(i)']);	% assign element node set pointer
         p=find(elems.x{j}(:,1,1)==sliceid(1));
         if ~isempty(p)
            m = length(elems.x{j}(p,:,2));
            z=eval(['u.' lab '{i}(p,:)']);
            h(l,k).line=plot(elems.x{j}(p,:,2),z,elems.x{j}(p,[1 m],2),z([1 m]),'+', ...
               'LineWidth',lw);
            h(l,k).text=text(mean(elems.x{j}(p,:,1)),max(z),int2str(i-1), ...
               'FontSize',20,'HorizontalAlignment','center','VerticalAlignment','middle', ...
               'Visible','off');
            l=l+1;
         end
      end,drawnow			% end element loop
   end					% end files loop
else					% slice for y=sliceid(1):
   for k=1:lt				% loop over files:
      eval(msg)				% display message
      eval(cmd)				% input data unless lt==1
      for i=1:elems.n			% loop over elements:
         j = eval(['u.' lab 'ic(i)']);	% assign element node set pointer
         p=find(elems.x{j}(1,:,2)==sliceid(1));
         if ~isempty(p)
            m = length(elems.x{j}(:,p,1));
            z=eval(['u.' lab '{i}(:,p)']);
            h(l,k).line=plot(elems.x{j}(:,p,1),z,elems.x{j}([1 m],p,1),z([1 m]),'+', ...
               'LineWidth',lw);
            h(l,k).text=text(mean(elems.x{j}(:,p,1)),max(z),int2str(i-1), ...
               'FontSize',20,'HorizontalAlignment','center','VerticalAlignment','middle', ...
               'Visible','off');
            l=l+1;
         end
      end,drawnow			% end element loop
   end					% end files loop
end
grid on
