function h = specelem(elems,u,ifig,lab,invis,lw)
%
% h = specelem(elems,u,ifig,lab);
% h = specelem(elems,u,ifig,lab,invis);
% h = specelem(elems,u,ifig,lab,invis,lw);
%
% As in meshelem, given structures elems & u (e.g., from gbin_input),
% create a spectrum plot in figure ifig, of variable
% labled lab; return graphics objects handles h{1:elems.n,1:6}.
% The 1st column of h contains patch-object handles, column 2 are
% element-no. handles, and columns 3:6 are element-edge handles,
% to lines of width lw (default 3).
% If included, invis is a list (e.g., 1 or 3:6 or [1 4:5] etc.)
% of h columns to be invisible.
% Enter "u<Enter>" to see the labels of u.
%
if nargin<6
   lw=3;
end
figure(ifig)				% set current figure window
clf					% clear figure
hold on					% don't overwrite objects
idxs = {':,1' 'nx,:' ':,ny' '1,:'};	% edge indexes
for i=1:elems.n				% loop over elements:
   j = eval(['u.' lab 'ic(i)']);	% assign element node set pointer
   x = elems.x{j};			% nodes of element i
   [nx ny]=size(x(:,:,1));		% nos. 2D nodes
   [x y] = meshgrid(x(1,1,1)+(0:nx-1)*(x(nx,1,1)-x(1,1,1))/nx, ...
      x(1,1,2)+(0:ny-1)*(x(1,ny,2)-x(1,1,2))/ny);
   U = log2(dLt(dLt(eval(['u.' lab '{i}'])'),2).^2);
   h{i,1}=surf(x,y,U);
   h{i,2}=text(mean(mean(x)),mean(mean(y)),max(max(U)),int2str(i-1),'FontSize',20, ...
      'HorizontalAlignment','center','VerticalAlignment','middle');
   for k=1:4				% loop over element i's 4 edges:
      h{i,2+k}=eval(['line(x(' idxs{k} '),y(' idxs{k} '),U(' ...
         idxs{k} '),''LineWidth'',lw)']);
   end
end
if nargin>4				% invis was passed in:
   for i=1:elems.n			% loop over elements:
      for k=invis			% loop over graphics objects:
         set(h{i,k},'Visible','off');
      end
   end
end
daspect(daspect*[.5 .5 0;.5 .5 0;0 0 1])% set data aspect ratio
grid on
view(3)					% default 3D view
colormap(rwbmap(64))			% nice color map
