function ustat=statelem(elems,u,lab,fi)
%
% ustat=statelem(elems,u,lab);
% ustat=statelem(elems,u,lab,'fi(x)');
%
% Return spatial statistics of field labeled lab:
% ustat.hmax = max element length
% ustat.hmin = min element length
% ustat.ul2n = u L2 norm accurate to degree p-1
% ustat.umax = max u
% ustat.umin = min u
% ustat.ummax = max |u|
% ustat.uxmin = min finite-difference du/dx
% ustat.xuxmin(1:2) = location of min du/dx
% if nargin>3:
%    ustat.dmmax = max |u-fi(x)|
%    ustat.dl2n = (u-fi(x)) L2 norm accurate to degree p-1
%
% Pass 'fi(x)' as an expression string such as
%  'sin(pi*(x(:,:,1)+2*x(:,:,2)))' or
%  'BurgersH(1e-3,  1.234       ,x,50,0,0,[1 2])' or (more accurately)
% ['BurgersH(1e-3,' mat2str(t) ',x,50,0,0,[1 2])']
% where t has a value in the calling workspace.
%
persistent podeold np w
pode=size(elems.x{1},1)-1;		% assume same degree for both dimensions, all elements
if isempty(podeold)			% then this is 1st call:
   flag=true;
elseif podeold~=pode			% then pode changed:
   flag=true;
else
   flag=false;
end
if flag
   podeold=pode;			% update podeold
   np=pode+1;				% no. 1D polynomials
   [xi w]=GausLoba(pode);		% nodes and weights on [-1,1]
   w=.25*w'*w;				% 2D weight matrix on [0,1]^2
   w=w(:)';				% shape it as a row
end
ustat=struct('hmax',-Inf,'hmin',Inf,'ul2n',0,'umax',-Inf,'umin',Inf,'ummax',-Inf,'uxmin',Inf);
rt=0;
for i=1:elems.n				% loop over elements:
   j=eval(['u.' lab 'ic(i)']);		% index to element-i coordinates
   siz = size(elems.x{j}(:,:,1));
   z=eval(['u.' lab '{i}']);		% values in element i
   du=diff(z)./diff(elems.x{j}(:,:,1));	% x-derivative (finite difference)
   [du r]=min(du(:));
   if du<ustat.uxmin
      ustat.uxmin=du;			% update min
      [p q]=ind2sub(siz,r);		% indexes of min
      ustat.xuxmin(1:2)=elems.x{j}(p,q,:);
   end
   r=(elems.x{j}(np,1,1)-elems.x{j}(1,1,1))*(elems.x{j}(1,np,2)-elems.x{j}(1,1,2));
   z=z(:);
   ustat.ul2n=ustat.ul2n+w*z.^2*r;	% L2 norm^2
   rt=rt+r;
   r=sqrt(r);				% area -> length
   ustat.hmax=max([ustat.hmax r]);	% max element length
   ustat.hmin=min([ustat.hmin r]);	% min element length
   ustat.umax=max([ustat.umax
                   z]);			% max value
   ustat.umin=min([ustat.umin
                   z]);			% min value
   ustat.ummax=max([ustat.ummax
                    abs(z)]);		% max abs value
end
ustat.ul2n=sqrt(ustat.ul2n/rt);		% L2 norm
if nargin>3
   fi=inline(fi);
   ustat.dmmax=-Inf;			% initialize max |u-fi(x)|
   ustat.dl2n=0;			% initialize (u-fi(x)) L2 norm
   rt=0;
   for i=1:elems.n			% loop over elements:
      j=eval(['u.' lab 'ic(i)']);	% index to element-i coordinates
      z=eval(['u.' lab '{i}'])-fi(elems.x{j});
      z=z(:);
      ustat.dmmax=max([ustat.dmmax
                       abs(z)]);	% max |u-fi(x)|
      r=(elems.x{j}(np,1,1)-elems.x{j}(1,1,1))*(elems.x{j}(1,np,2)-elems.x{j}(1,1,2));
      ustat.dl2n=ustat.dl2n+w*z.^2*r;	% (u-fi(x)) L2 norm^2
      rt=rt+r;
   end
   ustat.dl2n=sqrt(ustat.dl2n/rt);	% (u-fi(x)) L2 norm
end
