function [h,fx,fy,xt,yt] = ...
   streelem(elems,u,ifig,ilist,sx,sy,xt,yt,stepsize,maxverts)
%
% [h fx fy xt yt] = streelem(elems,u,ifig,ilist,sx,sy,xt,yt,stepsize,maxverts);
%
% Given structures elems & u (e.g., from gbin_input),
% create streamline plot in figure window ifig,
% for elements i=ilist (default 1:elems.n),
% using (and updating) tickmarks (xt,yt) (default ([],[])),
% with steps of length stepsize (default .1) and
% at most maxverts (default 10000) vertices per streamline.
% Start vertices for element i=1:length(ilist) are (sx(:,:,i),sy(:,:,i))
% (defaults to uniform element-interior grid).
% Label x-y axes by l2 errors in u-v.
% Return h{1:length(ilist)}, the graphics objects handles,
% and (fx{:,:,i},fy{:,:,i}), the streamline finish vertices.
%
% Example: see Kovasznay.m.
%
if nargin<4
   ilist = 1:elems.n;			% from element 1 to elems.n
end
if nargin<7
   xt = [];				% x ticks
end
if nargin<8
   yt = [];				% y ticks
end
if nargin<9
   stepsize = .1;			% stream2 default
end
if nargin<10
   maxverts = 10000;			% stream2 default
end
figure(ifig)				% set active figure
e=zeros(1,2);				% initialize l2 error
for i=ilist				% loop over elements
   j = u.V1ic(i);			% assign pointer to element node set
   x = elems.x{j}(:,:,1)';		% assign x coordinates
   y = elems.x{j}(:,:,2)';		% assign y coordinates
   if nargin<5				% assign uniform start vertices
      lx = linspace(x(1,1),x(1,end),9);	% assign streamline start x's
      ly = linspace(y(1,1),y(end,1),9);	% assign streamline start y's
      lx = .5*(lx(1:8)+lx(2:9));	% trick to avoid element edge
      ly = .5*(ly(1:8)+ly(2:9));
      [sx(:,:,i) sy(:,:,i)]=meshgrid(lx,ly);
   end
   [ly lx]=size(sx(:,:,i));		% dimensions of start-vertex array
   XY=stream2(x,y,u.V1{i}',u.V2{i}',sx(:,:,i),sy(:,:,i),[.1 maxverts]);
   h{i}=streamline(XY);			% plot forward streamline curves
   k = 1;				% index into XY
   for kx=1:lx				% loop over x-coords
      for ky=1:ly			% loop over y-coords
         if isempty(XY{k})
            [fx{ky,kx,i},fy{ky,kx,i}]=deal([]);
         else
            fx{ky,kx,i}=XY{k}(:,1);	% assign stream x-coords
            fy{ky,kx,i}=XY{k}(:,2);	% assign stream y-coords
         end
         k = k+1;
      end
   end
   e(1)=e(1)+norm(u.V1{i}-u.V1A{i})^2;	% accumulate l2 error
   e(2)=e(2)+norm(u.V2{i}-u.V2A{i})^2;	% accumulate l2 error
   xt = [xt;elems.x{j}(:,1,1)];		% accumulate x ticks
   yt = [yt elems.x{j}(1,:,2)];		% accumulate y ticks
end
axis equal				% equal scales in x & y
axis tight				% crop tight to data
grid on					% show node lines
orient tall				% fill printed page
orient landscape			% rotate 90 deg
xt=sort(unique(xt));
yt=sort(unique(yt));
set(gca,'XTick',xt,'YTick',yt)
xlabel(sprintf('{%s} (%s_2=%7.1e)','\itu','\epsilon',sqrt(e(1))))
ylabel(sprintf('{%s} (%s_2=%7.1e)','\itv','\epsilon',sqrt(e(2))))
