function w=unopelem(elems,u,op,labu,labw)
%
% w=unopelem(elems,u,'op(x,u)','labu','labw');
%
% Assign to w field 'labw' a unary operation on the u field 'labu'.
% The 'op(x,u)' can be an expression like 'sin(u)+x(:,:,1)-x(:,:,2)'.
% Note 'op(x,u)' uses 'u' for any 'labu',
% and 'labw' must be an acceptible field name.
%
nelem=length(eval(['u.' labu]));	% no. elements
if ~exist(op,'builtin')			% then op contains an expression:
   op=inline(op,'x','u');
end
for k=1:nelem
   j=eval(['u.' labu 'ic(k)']);		% coordinate index
   x=elems.x{j};			% coordinates
   v=eval(['u.' labu '{k}']);		% field
   z=feval(op,x,v);
   eval(['w.' labw '{k}=z;'])
   eval(['w.' labw 'ic(k)=j;'])
end
