//************************************************************************************
// Module       : dd_rect.hpp
// Date         : 7/17/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the object that decomposes a general 2d (3d) rectangular
//                (cubic) domain into a specified number of elements in each
//                coordinate direction.
// Derived From : none.
// Modifications:
//************************************************************************************
#if !defined(DD_RECT_HPP)
#define DD_RECT_HPP 
#include "gtypes.h"
#include "point.hpp"

class DD_Rect
{
public:
                         DD_Rect();
                         DD_Rect(GFLOAT *X0, GFLOAT *X1, GINT    n);
//                       DD_Rect(const DD_Rect &);
                         ~DD_Rect();
         GBOOL           DoPart();                                                    // Do the partitioning
         void            SetDomain(GFLOAT *X0, GFLOAT *X1, GINT    n);
         void            SetPartSize(GINT    Nx, GINT    Ny, GINT    Nz=0);
         void            SetElemDescretization(GLONG Nx, GLONG Ny, GLONG Nz=0);
         GBOOL           SetBoundaryCond(GFLOAT *P0, GFLOAT *P1, GINT    n, BDYTYPE btype);  
         GBOOL           SetCorners(GINT    n, BDYTYPE btype);                       // Set bdy cond on corner nodes 
         GBOOL           ResetPeriodic();                                            // Relabels periodic nodes
         GINT            NumVertices() ;
         GINT            **GetNeighborList();
         GINT            *GetNeighborNum();
         GLONG           **GetNodeIDs();
         GLONG           *GetNodeNum();
         GLONG           GetNodeDynRange();
         GFLOAT          *GetGraphVertexCoords(GINT    idir);
         void            **GetDualVertexCoords ();
         GLONG           **GetBdyNodeIndices();
         GLONG           *GetBdyNodeNum();
         BDYTYPE         **GetBdyCond();
         GINT            **GetbBdy();
         Point3D         *GetDomainVertices();
         GINT             GetNumDomainVertices();


private:
//    methods:
         GBOOL             DoPart1D();                                                       // Do the  1d partitioning
         GBOOL             DoPart2D();                                                       // Do the 2d partitioning
         GBOOL             DoPart3D();                                                       // Do the 3d partitioning
         void              DoPeriodic(GINT    idir, GBOOL bval);
         void              DeleteDynamic();                                                  // Delete all dynamic quantities
         GBOOL             CreateDynamic();                                                  // Create all dynamic quantities
         GBOOL             Set1dBdyCond(GFLOAT *P0, GFLOAT *P1, GINT    n, BDYTYPE btype);   // Set bcs for 1d problem
         GBOOL             Set2dBdyCond(GFLOAT *P0, GFLOAT *P1, GINT    n, BDYTYPE btype);   // Set bcs for 2d problem
         GBOOL             Set3dBdyCond(GFLOAT *P0, GFLOAT *P1, GINT    n, BDYTYPE btype);   // Set bcs for 3d problem
         GBOOL             bCornerNode(GINT    node, GINT    &ivertex);                      // Is node a corner node?

//    data:
         GBOOL           bPartitioned;       // Has partitition been done?
         GBOOL           bPeriodic[3];       // Periodicity flag--adjusts node_ids for periodic bc's
         GINT            nd;                 // Number of spatial dimensions
         GINT            nv;                 // Number of graph vertices 
         GINT            NE[3];              // Number of elements in the x-, y-, and z-dir
         GLONG           NN[3];              // Number of nodes/descretization in the x-, y-, and z-dir
         GLONG           node_dyn_range;     // Dynamic range for node ids
         GFLOAT          P0[3];              // Position of lower left corner
         GFLOAT          P1[3];              // Position of diagonal right corner
         GINT            **neighbors;        // Neighbor list; one list for each graph  vertex       
         GINT            *nne;               // Number of negibors for each graph  vertex       
         GLONG           *nno;               // Number of nodes for each graph  vertex       
         GLONG           *bnno;              // Number of bdy nodes for each graph  vertex       
         GLONG           **node_ids;         // Node id's; a set for each vertex
         GLONG           **bdy_node_indices; // Boundary node id's; an index set for each vertex points to node_ids elements
         GLONG           **bdy_ids;          // For each boundary node id, tells which bdy it lies on (0-3)
         GINT            ncorner_ids;        // Number of bdy nodes that are duplicated
         GLONG           *lcorner_ids;       // Local corner bdy node indices 
         GLONG           *gcorner_ids;       // Global corner bdy node indices 
         GINT            *ivert;             // Dual vert. index corresp. to corner bdy nodes
         BDYTYPE         **bcs;              // Boundary condition for each of the boundary nodes
         GINT            **bdyn;             // Is bdy global bdy?
         GFLOAT          **graph_coords;     // Graph vertex coordinate lists; one coord of length nv for each direction
         GFLOAT          **dual_coords1 ;    // Dual coordinate list; one list for each vertex       
         Point3D         **dual_coords2 ;    // Dual coordinate list; one list for each vertex       
         Point3D         **dual_coords3 ;    // Dual coordinate list; one list for each vertex       
         Point3D          *pV;               // Vertices of global domain

};

#endif
