//************************************************************************************//
// Module       : ab.hpp
// Date         : 11/8/04 (DLR)
// Copyright    : 2004-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                specifying and computing coefficients in an
//                Adams-Bashforth scheme with variable timestep.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(AB_HPP)
#define AB_HPP

#include "gtbuffer.hpp"


class AB 
{
public:
                  AB(GSHORT iorder=2);
                 ~AB();
                  AB(const AB &a);

void              SetOrder(GSHORT iorder); 
void              SetTimestepHistory(GDBuffer *dthist); 
GDBuffer          *GetCoeffs();
GDBuffer          *GetTimestepHistory();
void              ComputeCoeffs();
friend ostream&   operator<<(ostream&, AB &);                                  // Output stream operator
GDOUBLE           &operator()(const GSHORT  i);
GDOUBLE           &operator[](const GSHORT  i);



private:
// Private methods:

// Private data:
GSHORT            iorder_;              // specified AB order
GSHORT            maxorder_;            // max AB order allowed by class
GDBuffer          coeffs_;              // buffer of AB coeffs
GDBuffer          *dthist_;             // timestep history pointer, managed outside of class
};
#endif

