//************************************************************************************//
// Module       : diagop.hpp
// Date         : 6/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the Diag operator
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(DIAGOP_HPP)
#define DIAGOP_HPP 

#include "linop.hpp"
#include "gtbuffer.hpp"
#include "gtvector.hpp"
#include "elem2d.hpp"

class DiagOp: public LinOp 
{
public:
                           DiagOp();
                           DiagOp(GINT  n);
                           DiagOp(GDBuffer  *diag);
                           DiagOp(GVector *diag);
                           DiagOp(GDOUBLE *diag, GINT  n);
                           DiagOp(Elem2D *e);
                          ~DiagOp();

         GVector           operator*(GVector ) ;                   // Multiply operator on the RHS by vector
         GVector          *GetDiag();                               // Get diagonal vector
         void              OpVec_prod(GVector &x, GVector &ret);  // \* operator, with no vector copy or = 
         void              SetDiag(GDOUBLE *diag_elems, GINT   num ); // Set diagonal elements
         void              SetMask(GVector *m);
         void              Resize(GINT  NN);
         void              Inverse();

private:

       
         GINT      n;
         GBOOL     bInverse;
         GVector  *diag;
         GVector  *diag0;

};

#endif
