//************************************************************************************//
// Module       : elem2d.hpp
// Date         : 9/14/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Abstract class forming the interface for 
//               all allowed 2D elements
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(ELEM2D_HPP)
#define ELEM2D_HPP 

#include "gtvector.hpp"
#include "gtmatrix.hpp"
#include "gnbasis.hpp"
#include "gmortar1d.hpp"
#include "gneighbor.hpp"
#include "gtlist.hpp"
#include "gmemmgr.hpp"
#include "mtk.hpp"

class GMortar1D;
class Elem2D 
{
public:
                        Elem2D(GSHORT ntmp=2);
virtual                ~Elem2D();
//virtual void          operator=(const Elem2D &);
                   
virtual ELEMTYPE        ElemType(){return elemtype_;}
virtual GINT            Dim(){return GDIM;}
        GINT            GetOrder(const GINT  idir);
        GINT            GetNumNodes();
virtual GDOUBLE         Integrate(GVector *v, GDOUBLE *multiplicity=NULL)=0;
virtual GDOUBLE         PIntegrate(GVector *v, GDOUBLE *multiplicity=NULL)=0;
virtual GBOOL           Differentiate(GVector *dv, GVector *v, GINT  idir)=0;
virtual GBOOL           DifferentiateWithMass(GVector *dv, GVector *v, GVector* tmp, GINT  idir)=0;
virtual GBOOL           DifferentiateWeak(GVector *dv, GVector *v,GVector* tmp, GINT  idir)=0;
        GVector         *GetTemp();
        GVector         *GetTemp(GSHORT i);
        GMemMgr         *GetTempMgr();
        GBOOL           TempLock(GVector *vec);
        GBOOL           TempUnlock(GVector *vec);
        GDOUBLE         GetArea();        
        GDOUBLE         GetMinEdgeLength();
        GDOUBLE         GetMaxEdgeLength();
        Point3D         *GetSpVertices(GINT  ivertex=-1);
        Point3D         *GetSpMidpoints(GINT  iEdge=-1); 
        Point3D         *GetElemCenter(); 
        GDOUBLE         *GetSpvVertices(); 
        GINT            GetNumVertices(); 
        GINT            GetNumEdges(); 
        GINT            GetNumFaces(); 
        void            Vertex2EdgePoint(GINT  iedge[], GINT  ipoint[], const GINT  ivert);
        GINT            EdgePoint2Vertex(const GINT  ie, const GINT  ip);
        void            Edge2Vertex(GINT  iv[], const GINT  ie);
        GBOOL           isVirtualVertex(GINT  iedge, GINT  iendpoint);
        GBOOL           GetCommonVertex(GINT  &icedge, GINT  &icendpoint, 
                                        const GINT  iedge, const GINT  iendpoint);
        void            GetVertexCommonEdges(GINT  icedge[], GINT  icendpoint[], const GINT  ivertex); 
        GMortar1D       *GetEdgeMortar(GINT  iedge=-1); 
        GIBuffer        *GetEdgeIndices(GINT  iedge=-1); 
        GIBuffer        *GetEdgeIndicesN(GINT  iedge=-1); 
        GIBuffer        *GetInteriorIndices(); 
        GIBuffer        *GetVertexIndices(GINT  iedge=-1); 
        GVector         *GetNodalMultiplicity(); 
        GVector         *GetMask(); 
        GVector         *GetBdyMask(); 
        GNeighborList   *GetVNeighbor (GINT  ivertex=-1);
        GNeighborList   *GetVVNeighbor(GINT  ivertex=-1);
        GNeighborList   *GetENeighbor(GINT  iedge=-1);
        GIBuffer        *GetBdyIndices(); 
        GBTBuffer       *GetBdyTypes(); 
        BDYTYPE         &GetVertType(GINT  i); 
        BDYTYPE         &GetEdgeType(GINT  i); 
        BDYTYPE         &GetFaceType(GINT  i); 
        GINT            &bGlobalBdyEdge(GINT  i); 
        void            ComputeBdyInfo(); 
#if defined(IS3D)
        GINT            GetNumFaces(); 
        GMortar2D       *GetFaceMortar(GINT  iface=-1); 
        GIBuffer        *GetFaceIndices(GINT  iface=-1); 
        BDYTYPE         &GetFaceType(GINT  i); 
#endif
        GKEY            GetID(); 
        GKEY            GetParentID(); 
        GKEY            GetRootID();  
        GDOUBLE         GetiRootID();  
#if 0
        GVector         *GetTmp(GINT  iwhich=0);
        GINT            GetNTmp();
#endif
        GNBasis         *GetDBasisObj(GINT  idir);
virtual GNBasis         *GetBasisObj(GINT  idir)=0;
virtual GVector         *Get1DWeights(GINT  idir)=0;
virtual GVector         *GetXiNodes(GINT  idir)=0; 
virtual GMatrix         *Get1DDerivMatrix(GINT  idir, GBOOL bTranspose)=0;  
virtual GMatrix         *Get1DDerivMatrixWithMass(GINT  idir, GBOOL bTranspose)=0;  
virtual GMatrix         *Get1DDerivMatrixWeak(GINT  idir, GBOOL bTranspose)=0;  
virtual GMatrix         *Get1DStiffMatrix(GINT  idir, GBOOL bTranspose)=0;                 
virtual GVector         *Get2DWeights()=0;                              
virtual GVector         *GetMassMatrix()=0;                            
virtual GVector         *GetiMass()=0;
virtual GVector         *GetgMass()=0;
virtual GBOOL           Assemble()=0;
virtual GVector         *GetSpNodes(GINT  idir)=0;                     
virtual GMatrix         *GetInterpOp(GINT  idir, GBOOL Transpose)=0;
virtual GMatrix         *GetInterpDeriv(GINT  idir, GBOOL Transpose)=0;
//virtual GVector       *GetJacobian()=0;                              
//virtual GVector       *GetdXidX(GMatrix **, GINT  )=0;              
//virtual GVector       *GetdXidX   (const GINT  i, const GINT  j )=0; 
//virtual GVector       *GetMetric  (const GINT  i, const GINT  j )=0; 
//virtual GVector       *GetWJMetric(const GINT  i, const GINT  j )=0; 

virtual GBOOL            XToXi(Point3D pX[], Point3D pXi[], const GINT  n)=0;
GBOOL                    Interp(GVector *Ufrom, Point3D *xto, GINT  *ito, GINT  nto, GVector *Uto);
GDOUBLE                  Interp(const GSHORT  iLevel, const GDOUBLE x, const GDOUBLE y);      

GBOOL                    Map2NewCoords(GVector *oldU, GVector *newX[], GINT  nc, GINT  *inew, GINT  ni,
                                       GVector *newU, GIBuffer  *&iremap);  

//virtual GMatrix       *GetBasisAtXi(GINT  i, GINT  j, GMatrix *B)=0;
        void             SetID(GKEY id); 
        void             SetParentID(GKEY id); 
        void             SetRootID(GKEY id);  
        void             SetBasis(GNBasis *b1, GNBasis *b2)  ;
        void             SetBasis(GNBasis *b, GINT  idir)  ;
        void             SetDBasis(GNBasis *b, GINT  idir)  ;
        GVector          *GetDMass()  ;
        GMatrix          *GetDJ   (GINT idir)  ;
        GMatrix          *GetDJT  (GINT idir)  ;
        GBOOL            DealiasingEnabled();

virtual GBOOL            ComputeSpNodes()=0;
virtual GBOOL            SetVertices(Point3D P[], GINT  num)=0;
virtual void             SetInterpBasis(GNBasis *b1, GNBasis *b2)=0;
        void             SetOrder(GINT  iorder1, GINT  iorder2);
virtual GBOOL            Resize(GINT  order1, GINT  order2)=0;
virtual GINT             SolveFE()=0;

virtual  GBOOL           Point_in_poly(Point3D V[], GINT , Point3D P[], GINT  num);
virtual  GBOOL           Point_in_poly(Point3D P[], GINT  num);
virtual  GBOOL           Point_in_poly(GDOUBLE x, GDOUBLE y);
  friend ostream& operator<<(ostream&, Elem2D &);    /// Output stream operator


inline GDOUBLE X1(GDOUBLE xi1, GDOUBLE xi2){ return 0.25*(spVertices[0].x1*(1.0-xi1)*(1.0-xi2)
                                                   +spVertices[1].x1*(1.0+xi1)*(1.0-xi2)
                                                   +spVertices[3].x1*(1.0-xi1)*(1.0+xi2)
                                                   +spVertices[2].x1*(1.0+xi1)*(1.0+xi2)); }                     



inline GDOUBLE X2(GDOUBLE xi1, GDOUBLE xi2){ return 0.25*(spVertices[0].x2*(1.0-xi1)*(1.0-xi2)
                                                   +spVertices[1].x2*(1.0+xi1)*(1.0-xi2)
                                                   +spVertices[3].x2*(1.0-xi1)*(1.0+xi2)
                                                   +spVertices[2].x2*(1.0+xi1)*(1.0+xi2)); }

inline GBOOL  AreEqual(Point3D P1, Point3D P2)
{if ( P1.x1==P2.x1 && P1.x2==P2.x2) return TRUE; else return FALSE;}

inline GBOOL  AreEqual(IPoint3D P1, IPoint3D P2)
{if ( P1.i1==P2.i1 && P1.i2==P2.i2) return TRUE; else return FALSE;}


protected:
        void            CreateElemDynamic();
        void            InitMortars();
        void            SetIndices(); 


GINT                    Np1;
GINT                    Np2;
GINT                    **iep2v_;
GBOOL                   bInitialized;
GBOOL                   bSolved;
ELEMTYPE                elemtype_;
GKEY                    elemid_;
GKEY                    parentid_;
GKEY                    rootid_;
GINT                    nVertices_;
GINT                    nEdges_;
GINT                    nFaces_;
Point3D                 *spVertices;
Point3D                 *spMidpoints;
Point3D                 *elemCenter;
GDOUBLE                 area_;
GDOUBLE                 irootid_;
GDOUBLE                 *spvVertices;
GVector                 *spNodes1;
GVector                 *spNodes2;
GNBasis                 *basis1;
GNBasis                 *basis2;
GNBasis                 *gbasis1;
GNBasis                 *gbasis2;

// Dealiasing quantities:
GNBasis                 *dealias_basis_[GDIM];
GMatrix                  JD_ [GDIM];           /// maps to dealias space
GMatrix                  JDT_[GDIM];           /// maps from dealias space
GVector                  DMassMatrix_;         /// dealias space mass matrix


//--------connectivity data--------
GMortar1D               *edge_mortars_;
GNeighborList           *vertex_neighbor_;
GNeighborList           *vvertex_neighbor_;
GNeighborList           *edge_neighbor_ ;
GIBuffer                *vert_indices_;
GIBuffer                *edge_indices_;
GIBuffer                *edge_indicesn_;
GIBuffer                *inter_indices_;
GIBuffer                *midpnt_indices_;
GVector                 *nodal_multiplicity_;
GIBuffer                *bdy_indices_;
GBTBuffer               *bdy_types_;
GBTBuffer               *vert_types_;
GBTBuffer               *edge_types_;
GBTBuffer               *face_types_;
GIBuffer                *bGlobal_edge_;
GVector                 *mask_;
GVector                 *bmask_;
#if defined(IS3D)
GINT                    nFaces_;
GMortar2D               *face_mortar_;
GNeighborList           *face_neighbor_;
GIBuffer                *face_indices_;
GBTBuffer               *face_types_;
#endif
GVector                 vtmp[G_NUM_ELEM_TMP];
GMemMgr                 *vtmpmgr_;
};

#endif
