//************************************************************************************//
// Module       : evforce.hpp
// Date         : 12/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                defining the state-independent Einaudi-Villi 
//                forcing function. This function is defined in
//                AIP S1070-664X(99)02711-1, s.t.
//                F_ = Curl ( f z^ ), where
//                  f = A_1(x,y) sin^2(Pi t/(2 t_*) + A_2(x,y) sin^2(Pi t/(2 t_*) + Pi/2),
//                with
//                A_i = Sum_m,n alpha^i_m,n sin(k_n x + k_m y + xi^i_m,n).
// Derived From : SIForce
// Modifications:
//************************************************************************************//
#if !defined(EVFORCE_HPP)
#define EVFORCE_HPP 

#include "siforce.hpp"


class EVForce: public SIForce
{
public:
                           EVForce();
                           EVForce(Elem2D *e);
                          ~EVForce();

         GVector          Accel(GDOUBLE time, GINT  idir) ; 
         GBOOL             Accel(GDOUBLE time, GINT  idir, GVector &ret) ; 
         GBOOL             Initialize();
         GBOOL             ParamSet(char *filename, char *blockname);
         void              SetElem(Elem2D *e);
         void              SetTurnoverTime(const GDOUBLE tt); 
         void              SetStartTime(const GDOUBLE ts); 
         void              SetWaveRange(GINT  idir, GDOUBLE k0, GDOUBLE k1);
         void              SetIndexRange(GINT  icomponent, GINT  idir, GINT  ib, GINT  ie); 
         void              DoRenormalization(GBOOL yn, GDOUBLE norm);

private:
         void              UpdateRand();
         void              ComputeDerivs(GINT  idir);

         GBOOL             bUpdated_;
         GBOOL             bRenormalized_;
         GBOOL             bInitialized_;
         GINT              ib_[2][2];  // beginning index for [A_component][direction: x, y] 
         GINT              ie_[2][2];  // end       index for [A_component][direction: x, y]
         GINT              imin;
         GINT              imax;
         GDOUBLE             last_time_;
         GDOUBLE             start_time_;
         GDOUBLE             turn_time_;
         GDOUBLE             A_avg_;
         GDOUBLE            *k_[2];
         GDOUBLE             kmin_[2];
         GDOUBLE             kmax_[2];
         GDOUBLE             *alpha_[2];
         GDOUBLE             *xi_[2];
         GDOUBLE             norm_[2];
         GVector          *vtmp;
         GVector          *dA_ [2];

};

#endif
