//************************************************************************************//
// Module       : ext.hpp
// Date         : 11/8/04 (DLR)
// Copyright    : 2004-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                specifying and computing coefficients in an
//                extrapolation-based scheme with variable timestep.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(EXT_HPP)
#define EXT_HPP

#include "gtbuffer.hpp"


class EXT 
{
public:
                  EXT(GSHORT iorder=2);
                 ~EXT();
                  EXT(const EXT &a);

void              SetOrder(GSHORT iorder); 
void              SetTimestepHistory(GDBuffer *dthist); 
GDBuffer          *GetCoeffs();
GDBuffer          *GetTimestepHistory();
void              ComputeCoeffs();
friend ostream&   operator<<(ostream&, EXT &);                                  // Output stream operator
GDOUBLE           &operator()(const GSHORT  i);
GDOUBLE           &operator[](const GSHORT  i);



private:
// Private methods:

// Private data:
GSHORT            iorder_;              // specified EXT order
GSHORT            maxorder_;            // max EXT order allowed by class
GDBuffer          coeffs_;              // buffer of EXT coeffs
GDBuffer          *dthist_;             // timestep history pointer, managed outside of class
};
#endif

