//************************************************************************************//
// Module       : field2d.hpp
// Date         : 9/14/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a single 2D spectral element field
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(FIELD2D_HPP)
#define FIELD2D_HPP
#include "elem2d.hpp"
#include "siforcelist.hpp"
#include "gmemmgr.hpp"

class Field2D 
{
public:
                  Field2D(GINT  Num_TimeLevels, Elem2D *e, GSHORT ntmp=2);
                 ~Field2D();
void              operator=(Field2D &);
void              operator=(GVector &);
void              operator=(GDOUBLE a);
                   
GBOOL             ResetOrder(const GSHORT  n1, const GSHORT  n2);      // Reset exp. order; re-interp all time levels
GBOOL             SetExpCoeffs (const GINT  iLevel,  GVector *);       // Set expansion coeffs for specified time level
GBOOL             SetExpCoeffs (GVector *);                            // Set expansion coeffs for 0-level; rotate others
void              SetTimeLevel(GINT ilevel);                           // Set time level for gets
void              ShiftLevels ();                                      // Shift time levels of exp coeffs
SIForceList       *GetSIForceList();                                   // Get state-indep force list for field element
GINT              GetNumTimeLevels();                                  // How many time levels being stored?
GVector           *GetExpCoeffs (const GINT  iLevel);                  // Get expansion coeffs for specified time level
GVector           **GetExpCoeffs ();                                   // Get expansion coeffs for all time levels 
GDOUBLE           GetTime(const GINT  iLevel);                         // Get evolution time at specified time level
void              SetTime(const GINT  iLevel, GDOUBLE t);              // Set evolution time corresp to specified time level
GVector           *GetTemp();                                          // Get temp space vector
GVector           *GetTemp(GSHORT i);                                  // Get specified temp space vector
GMemMgr           *GetTempMgr();                                       // Get temp vector mgr
GBOOL             TempLock(GVector *vec);                              // Lock temp vector
GBOOL             TempUnlock(GVector *vec);                            // Unlock temp vector
Elem2D            *GetElement  ();                                     // Get element
GVector           *GetBdyValues();                                     // Get bc info from (current) field

GDOUBLE           Interp(const GSHORT  iLevel, const GDOUBLE x, const GDOUBLE y);

GBOOL             Map2NewCoords(GVector *newX, GVector *newY, GIBuffer  *inew, GVector *newU,
                                const GINT  iLevel, GIBuffer  *iremap);  
                                                                       // Map from current elem to specified coords
GBOOL             Map2NewElem(Elem2D *newElement,  GVector *U[],
                               const GINT  nU, GIBuffer  *iremap);     // Map from current elem to specified element
GDOUBLE           ComputeUL2  (const GINT );                           // L-2 norm for u^2  
GDOUBLE           ComputeDUL2 (const GINT );                           // L-2 norm for Du/Dx
GDOUBLE           &operator    ()(const GSHORT  nLevel, const GLONG i);// Field member index value at time level n
           friend ostream& operator<<(ostream&, Field2D &);            // Output stream operator



private:

// Private methods:
GBOOL             Resize(GINT , GINT );                                // Resize dynamically allocated quantities
void              DeleteDynamic();                                     // Delete dynamically allocated quantities

// Private data:
GINT             Np1;              // 1-expansion order
GINT             Np2;              // 2-expansion order
GINT             NN1;              // No. 1-expansion nodes 
GINT             NN2;              // No. 2-expansion nodes 
GINT             iTot;             // Total no. expansion nodes
GINT             nTimeLevels;      // Number of time levels retained
GINT             iTimeLevel;       // Which time level to get/set, where appropriate
GBOOL            bInitialized;     // Has field been initialized?
GDOUBLE          *time;            // Time at time level n, n-1, n-2...
GNBasis          *basis1;          // 1-basis
GNBasis          *basis2;          // 2-basis
Elem2D           *elem;            // Associated element
SIForceList      *flist_ ;         // State-independent force list
GVector          **Un;             // Coeffs at time step n, n-1, n-2,...nTimeLevels (that at index nTimeLevels is temp space)
GVector          *u_bdy_;          // Bdy values
GMemMgr          *vtmpmgr_;        // temp-mem mgr


};

#endif
