//************************************************************************************//
// Module       : gadvect.hpp
// Date         : 8/9/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                an advection computation class.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GADVECTION_HPP)
#define GADVECTION_HPP

#include "gtypes.h"
#include "gelemlist.hpp"
#include "gfieldlist.hpp"
#include "gobjlist.hpp"
#include "gcomm.hpp"
#include "ab.hpp"
#include "ext.hpp"

class GAdvect 
{
public:
         enum TIME_EVOLTYPE {TE_OIFS=0, TE_ABBDF, TE_EXBDF, TE_EXBDF_Weak};

                           GAdvect(GFieldList *ulist[], GINT nfields, GElemList *uelems);
                          ~GAdvect();

         GBOOL             Advect(GVecList *padv, GVecList *temp, GDOUBLE time, GDOUBLE dt);// do advection
         void              SetEvolType(TIME_EVOLTYPE itype);
         void              SetAdvOrder (GINT iorder);
         void              SetBDFOrder(GINT iorder);
         void              SetTimestepHistory(GDBuffer *dthist);
         void              SetDoAdvection(GBOOL bdoadvect);
         void              SetNSubcycles(GINT nsub);
         void              SetAdvVel(GFieldList *cadv[], GINT ncadv);
         void              SetDoDealiasing(GBOOL bflag);
         GVecOpList       *GetVecOp();
         GDOUBLE           GetBDFSum();


private:
         GBOOL             AdvectABBDF     (GVecList *padv, GVecList *temp, GDOUBLE time, GDOUBLE dt);
         GBOOL             AdvectABBDF_Weak(GVecList *padv, GVecList *temp, GDOUBLE time, GDOUBLE dt);
         GBOOL             AdvectABBDF_D   (GVecList *padv, GVecList *temp, GDOUBLE time, GDOUBLE dt);
         GBOOL             AdvectRKBDF     (GVecList *padv, GVecList *temp, GDOUBLE time, GDOUBLE dt);
         GBOOL             AdvectInt       (GVector *uf[], GVector *ui[], GINT nf,
					    GINT ilevel,  GDOUBLE dt, GINT  ie);               // Integrate advect. terms in OIFS
         GBOOL             FixedStepAdvRKK (GVector *uf[], GVector *ui[], GINT nf,
					    GINT ilevel, GDOUBLE h, GINT  ie);         // Step advect integ. 
         void              ComputeTimeDepCoeffs();
         GBOOL             ResetExpandables();
         GBOOL             ElemListChange();
         void              BuildCoeffs();

         TIME_EVOLTYPE     itime_type_;
         GBOOL             bTimeDeriv_;
         GBOOL             bRotationalForm_;
         GBOOL             bDoAdvect_;
         GBOOL             bConstAdvVel_;
         GBOOL             bDoDealiasing_;
         GBOOL             bDealiasingEnabled_;
         GINT              irank_;
         GINT              nfields_;
         GINT              ntimelevels_;
         GINT              nelems_;
         GINT              iorderbdf_;
         GINT              iorderOIFS_RKK_;
         GINT              iorderadv_;
         GINT              nsubcycoifs_;
         GINT              nsubcycles_;
         GDOUBLE           c_bdf_[4][4];
         GDOUBLE           gamma0_;
         GDOUBLE           *alpha_;
         GDOUBLE           *beta_;
         AB                ab_;
         EXT               ext_;
         GDBuffer          *dthist_;
         GVecList          yt1[GDIM];
         GVecList          K1 [GDIM];
         GVecList          K2 [GDIM];
         GFieldList        *cadv_[GDIM];


         GElemList         *uelems_;
         GFieldList        *var_list_[GDIM];
         GVecOpList        vecop_;      // Vector collocation operator -- gives advection



};

#endif
