//************************************************************************************//
// Module       : gifilter.hpp
// Date         : 8/5/05 (DLR)
// Copyright    : 2005-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                an interpolation-based filter (Fischer & Mullen C.R. Acad. Sci.
//                Paris, 332(1), 265 (2001).
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(GIFILTER_HPP)
#define GIFILTER_HPP

#include "linop.hpp"
#include "elem2d.hpp"
#include "gllbasis.hpp"


class GIFilter: public LinOp
{
public:
                           GIFilter();
                           GIFilter(Elem2D *e, GDOUBLE alpha, GINT ismooth_delta_modes);
                          ~GIFilter();
                           GIFilter(const GIFilter &a);

         GVector           operator*(GVector) ; // Multiply operator on the RHS by vector
         void              OpVec_prod(GVector &x, GVector &ret);  
         void              SetElem(Elem2D *);
         Elem2D           *GetElem();
         void              SetStrength(GDOUBLE alpha);
         void              SetDelta(GINT idelta);


private:
// Private methods:
         GBOOL             Filter(GVector &v, GVector &vn);

// Private data:
         GINT              ismooth_delta_;             // smoothing mode range: N-ismooth_delta_
         GBOOL             deletehere_[GDIM];
         GDOUBLE           alpha_;                     // filter strength
         GMatrix          *Fn_[GDIM];                  // 1-d filter
         GLLBasis         *basisGLL_[GDIM];
         Elem2D           *elem;
};
#endif

