//************************************************************************************//
// Module       : gbasis.hpp
// Date         : 4/24/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a spectral element nodal Gauss-Legendre basis
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GBASIS_HPP)
#define GBASIS_HPP
#include "gtypes.h"
#include "gllbasis.hpp"


class GLBasis: public GLLBasis
{
public:

                           GLBasis();
                           GLBasis(GINT );
                           GLBasis(GINT  , GINT );
                           GLBasis(const GLBasis &);
virtual                   ~GLBasis();

         void              operator=(const GLBasis &);
                   
         GDOUBLE             EvalBasis (GINT  i, GDOUBLE xi);
         GVector          *EvalBasis (GINT  i, GVector *xi, GVector *vret);
         GMatrix          *EvalBasis (GVector *eta, GMatrix *mret);
         GMatrix          *EvalDBasis(GVector *eta, GMatrix *mret);


// Private methods:
private:

         GBOOL             ComputeNodes       ();
         GBOOL             ComputeWeights     ();
         GBOOL             ComputeDerivMatrix ();
         GBOOL             ComputeBasisAtNodes();
         GBOOL             ComputeLegendreMatrix();

         GBOOL             Resize(GINT  order);
//       void              DeleteDynamic();


// Private data:




};

#endif
