//************************************************************************************//
// Module       : gnbasis.hpp
// Date         : 7/9/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a spectral element basis. This is a pure virtual class, 
//                intended to form the interface to a general nodal basis object.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GNBASIS_HPP)
#define GNBASIS_HPP
#include "gtypes.h"
#include "gtmatrix.hpp"
#include "gtvector.hpp"


class GNBasis
{
public:

                                    GNBasis(){};
                                    GNBasis(GINT ){};
                                    GNBasis(GINT  , GINT ){};
                                   ~GNBasis(){};

//virtual         void              operator=(const GNBasis &)=0;
                   
  virtual         GDOUBLE           GetXimin ()=0;
  virtual         GDOUBLE           GetXimax ()=0; 
  virtual         GINT              GetOrder()=0;
  virtual         GVector          *GetXiNodes(GVector *)=0;
  virtual         GDOUBLE          *GetXiNodes(GDOUBLE   *, GINT  num)=0;
  virtual         QVector          *GetXiNodes()=0;
  virtual         GVector          *GetWeights(GVector *)=0;
  virtual         GDOUBLE          *GetWeights(GDOUBLE   *, GINT  num)=0;
  virtual         GMatrix          *GetStiffMatrix(GMatrix *)=0;
//virtual         GMatrix          *GetBasisAtNodes(GMatrix *)=0;
  virtual         GMatrix          *GetDerivMatrix(GMatrix *)=0;
//virtual         GDOUBLE          *GetDerivMatrix(GDOUBLE    *, GINT  num)=0;
  virtual         void              SetOrder(GINT  )=0;
  virtual         GDOUBLE           EvalBasis (GINT  i, GDOUBLE xi)=0;
  virtual         GVector          *EvalBasis (GINT  i, GVector *xi, GVector *vret)=0;
  virtual         GMatrix          *EvalBasis (GVector *eta, GMatrix *mret)=0;
  virtual         GMatrix          *EvalDBasis(GVector *eta, GMatrix *mret)=0;
  virtual         GMatrix          *GetLegMatrix(GMatrix *mret)=0;

  virtual         GBOOL             Solve ()=0;

};

#endif
