//************************************************************************************//
// Module       : gradop.hpp
// Date         : 6/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                defining a (collocated) gradient operator object
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(GRADOP_HPP)
#define GRADOP_HPP 
#if (defined(GRAD_LEVEL0_TIMING)||defined(GRAD_LEVEL1_TIMING)||defined(GRAD_LEVEL2_TIMING)||defined(GRAD_LEVEL3_TIMING))
#define DO_GRAD_TIMING
#endif

#include "gtvector.hpp"
#include "elem2d.hpp"
#include "timer.h"


class GradOp
{
public:
                           GradOp();
                           GradOp(Elem2D *e, GVector *v);
                          ~GradOp();

         GVector           Grad(const GINT  idir);   // Full gradient in direction idir              
         void              Grad(const GINT  idir, GVector &vret);   
         GVector           pGrad(const GINT  idir);  // Gradient in parent domain direction idir                
         void              pGrad(const GINT  idir,GVector &vret); 
         void              SetVar(GVector *v, GBOOL resize);
         void              SetElem(Elem2D *e);

#if defined(DO_GRAD_TIMING)
        GDOUBLE              GetTime(){return time_result;}
#endif
private:
         GBOOL             DefmQuadOp(GVector *newx, const GINT  idir);
         GBOOL             RectQuadOp(GVector *newx, const GINT  idir);
         GBOOL             TriangleOp(GVector *newx, const GINT  idir);


         Elem2D            *elem; // geometric element
         GVector           *var;  // variable whose gradient we seek
         GVector           *vn ;  // return vector
         GVector           *vt ;  // temporary vector
#if defined(DO_GRAD_TIMING)
         GDOUBLE             time_result;
#endif



};

#endif
