//************************************************************************************//
// Module       : helmholtzop.hpp
// Date         : 6/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the (weak) Helmholtz operator class.
//                  H = hc L + mc M
//                where hc and mc are settable constants, and
//                L is the Laplacian operator, and M is the mass operator
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(HELMHOLTZOP_HPP)
#define HELMHOLTZOP_HPP

#include "linop.hpp"
#include "elem2d.hpp"
#include "massop.hpp"
#include "laplacianop.hpp"

class HelmholtzOp: public LinOp 
{
public:
                           HelmholtzOp();
                           HelmholtzOp(Elem2D *e);
//                         HelmholtzOp(const HelmholtzOp &);
                          ~HelmholtzOp();

         GVector           operator*(GVector) ; // Multiply operator on the RHS by vector
         void              OpVec_prod(GVector &x, GVector &y);
         void              SetElem(Elem2D *);
         Elem2D            *GetElem();
         void              SetConst(GDOUBLE h, GDOUBLE m);
         void              SetConst(GDOUBLE h1, GDOUBLE h2, GDOUBLE m);

//       friend ostream&   operator<<(ostream&, const HelmholtzOp&);

private:
         GBOOL             DefmQuadOp(GVector *x, GVector *newx);
         GBOOL             RectQuadOp(GVector *x, GVector *newx);
         GBOOL             TriangleOp(GVector *x, GVector *newx);
  
         GDOUBLE          lc1;
         GDOUBLE          lc2;
         GDOUBLE          mc;
         MassOp          *Mass;
         LaplacianOp     *Laplacian;
         Elem2D          *elem;

};

#endif
