//************************************************************************************//
// Module       : ihelmholtzop.hpp
// Date         : 7/17/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the inverse to the local helmholtz operator
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(IHELMHOLTZOP_HPP)
#define IHELMHOLTZOP_HPP
#include "linop.hpp"
#include "helmholtzop.hpp"
#include "defquad2d.hpp"
#include "rectquad2d.hpp"
#include "diagop.hpp"

class iHelmholtzOp: public LinOp
{
public:
                           iHelmholtzOp();
                           iHelmholtzOp(LinOp *A);
                           iHelmholtzOp(Elem2D *e);
//                         iHelmholtzOp(const iHelmholtzOp &);
                          ~iHelmholtzOp();

         GVector           operator*(GVector) ; // Multiply precond by right-vector
         void              OpVec_prod(GVector &q, GVector &ret);
         void              SetConst(GDOUBLE clc, GDOUBLE cmc);
         void              SetConst(GDOUBLE clc1, GDOUBLE clc2, GDOUBLE cmc);
         void              SetElem(Elem2D *e);


private:
         GBOOL             DefmQuadH();
         GBOOL             RectQuadH();
         GBOOL             TriangleH();
         GBOOL             ComputeOp();

         GINT              N1;     // 1-size 
         GINT              N2;     // 2-size 
         GINT              NN;     // 1 X 2 - size 
         GDOUBLE           lc1;    // Laplacian-multiplicative constant
         GDOUBLE           lc2;    // Laplacian-multiplicative constant
         GDOUBLE           mc;     // Mass matrix-multiplicative constant
         Elem2D           *elem;
         GMatrix          *H;
         GMatrix          *iH;


};

#endif
