//************************************************************************************//
// Module       : ipoint.cpp
// Date         : 8/20/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the access methods and data associated with
//                defining an GINT  point
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "ipoint.hpp"
#include <string>

//************************************************************************************
//************************************************************************************
// Constructor Method (1) 
IPoint::IPoint()
:
i1        (0),
i2        (0),
i3        (0)
{
  pix_[0] = &i1;
  pix_[1] = &i2;
  pix_[2] = &i3;
} // end of constructor method (1)


//************************************************************************************
//************************************************************************************
// Destructor
IPoint::~IPoint()
{
}

//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method
// DESCRIPTION: output stream operator
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
ostream &operator<<(ostream &str, IPoint &a)
{
  GINT  i;

  str << "("  << a[0];
  for ( i=1; i<GDIM; i++ )
  str << ", " << a[i];
  str << ")";
  return str;
} // end of operator <<
