//************************************************************************************//
// Module       : massop.hpp
// Date         : 6/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the mass (weak Laplacian) linear operator
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(MASSOP_HPP)
#define MASSOP_HPP

#include "linop.hpp"
#include "diagop.hpp"
#include "elem2d.hpp"


class MassOp: public LinOp 
{
public:
                           MassOp();
                           MassOp(Elem2D *e);
//                         MassOp(const MassOp &);
                          ~MassOp();

         GVector           operator*(GVector) ;                   // Multiply operator on the RHS by vector
         void              OpVec_prod(GVector &x, GVector &ret); // \* operator, with no vector copy or = 
         void              SetElem(Elem2D *);
         void              SetMask(GVector *);
         void              SetConst(GDOUBLE c);
         GVector          *GetDiag();
         void              Inverse();


//       friend ostream&   operator<<(ostream&, const MassOp&);

private:
         GBOOL            QuadOp    (GVector *x, GVector *newx);
         GBOOL            TriangleOp(GVector *x, GVector *newx);
         GDOUBLE          cmc_;
         GVector          *mask; 
         Elem2D           *elem;
         DiagOp           *MM;

};

#endif
