//************************************************************************************//
// Module       : ns.hpp
// Date         : 8/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the solver for the Navier-Stokes equations. The problem solved is
//                du/dt + u.Del u + 1/rho Del p -  nu_  Del^2 u = 0
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(NAVIER_STOKES_SOLVER_HPP)
#define NAVIER_STOKES_SOLVER_HPP 

#include "gstepper.hpp"
#include "cg.hpp"
#include "gttlist.hpp"
#include "gelemlist.hpp"
#include "gfieldlist.hpp"
#include "glinoplist.hpp"
#include "gobjlist.hpp"
#include "gadvect.hpp"
#include "stokes.hpp"
#include "ab.hpp"
#include "ext.hpp"
#include "glop.hpp"

class NavierStokes : public GStepper
{
public:
         enum TIME_EVOLTYPE {TE_OIFS=0, TE_ABBDF, TE_EXBDF};

                           NavierStokes(GFieldList *ulist[], GINT nf, GElemList *uelems, GElemList *pelems, GINT t);
                          ~NavierStokes();

         GBOOL             Step(GDOUBLE dt);                                              // Take one time step
         GDOUBLE           GetIntegTime();                                                // Get total integration time
//       GDOUBLE           TimeStep();                                                    // Get minumum timestep


         void              SetEvolType(TIME_EVOLTYPE itype);                     // Set time stepping scheme
         void              SetFields(GFieldList *u1list, GFieldList *u2list, 
                                     GFieldList *pelist);
                                                                                          // Set field list
         void              SetComm(GS  *ggs);                                             // Set global gather scatter operator
         GCHandle          SetCommHandle(GCHandle hIn) ;                                  // Initializes comm with existing handle 
         void              SetVisc(const GDOUBLE nu);                                     // Set kinematic viscosity, nu
         void              SetVisc(const GDOUBLE nu, GINT idir);                          // Set kinematic viscosity, nu
         void              SetDen(const GDOUBLE rho);                                     // Set const. density
         void              SetPreconditioner(GINT iwhich, GPC type );
         void              SetAdvOrder(GINT  iorder);                                     // Sets order of Adams-Bashforth explicit advection approx.
         void              SetBDFOrder(GINT  iorder_bdf);                                 // Sets order of BDF time approx.
         void              SetFilter(GLinOpList *filter);                                 // Sets filter operator
         StokesSolver      *GetStokes() { return stokes_; }                               // Get Stokes operator
         GDOUBLE           GetDivMax(GINT  iLevel);                                       // Get max(divergence V ) for time level iLevel
         void              DivV(GFieldList *divv);                                        // Compute Div.V field
         CG                *GetSolver(GINT iwhich);
         void              SetVBdyData (GINT  idir, GVecList *bdy_vals);                  // Set bcs for component idir
         void              SetTimestepHistory(GDBuffer *dthist);                          // Set timestep hist. buffer for AB/Ext methods
         void              SetNSubcycles(GINT nsub);                                      // Set number of OIFS subcycles

         void              SetTime(GDOUBLE t);                                            // Set stepper time
         void              SetDoAdvection(GBOOL bflag);                                   // Set Do Advect flag
         void              SetDoDealiasing(GBOOL bflag);                                  // Set Do Dealiasing flag
         GBOOL             ResetExpandables();                                            // Create  dynamically-allocated list-dependent quantities

private:
         // Methods:
         GBOOL             DoNormalStep(GDOUBLE dt);                                      // Step with adv. from GAdvect
         void              DeleteDynamic();                                               // Delete dynamically-allocated list-dependent quantities
         GBOOL             Advect(GDOUBLE dt, GINT  &iLevel);                             // Do advection 
         GBOOL             ElemListChange();                                              // Determine if element list has changed




         // Field and other data:
         GCHandle          hDSOp;
         TIME_EVOLTYPE     itime_type_;
         STOKES_TYPE       iStokes_type_;
         GBOOL             bInitReqd_;
         GBOOL             bDoAdvect_;
         GINT              irank_;
         GINT              nelems_;
         GINT              ntimelevels_;
         GINT              icycle_;
         GDOUBLE           maxCFL_;
         GDOUBLE           dt_curr_;
         GDOUBLE           dt_last_;
         GDOUBLE           time_;
         GDOUBLE           rho_;
         GFieldList        *var_list_[GDIM+1];
         GElemList         *uelems_;
         GElemList         *pelems_;
         GVecList          *ubdyvals[GDIM];
         GVecList          pu_[GDIM];
         GVecList          Nj_[GDIM];


         // Math operators
         GAdvect          *advect_;    // (macro) Advection operator 
         StokesSolver     *stokes_;    // Stokes solver

         // Communication:
         GS               *gsop;       // communication operator
      
};

#endif
