//************************************************************************************//
// Module       : siforce.hpp
// Date         : 12/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                defining a (collocated) forcing function. This
//                is the base class for all such forcing funtions.
// Derived From : none
// Modifications:
//************************************************************************************//
#if !defined(SIFORCE_HPP)
#define SIFORCE_HPP 

#include "gtvector.hpp"
#include "elem2d.hpp"


class SIForce
{

public:
                           SIForce();
                           SIForce(Elem2D *e);
                          ~SIForce();

virtual  GVector           Accel (GDOUBLE time, GINT  idir)=0 ; 
virtual  GBOOL             Accel(GDOUBLE time, GINT  idir, GVector &ret)=0 ; 
virtual  GBOOL             Initialize(){return TRUE;} ; 
virtual  void              SetElem(Elem2D *e);
         void              SetTimeStep(const GDOUBLE t); 
         void              SetDensity(const GDOUBLE d) ;

protected:

         GINT              rank_;
         GINT              idims_[3];
         GINT              NN_;
         GDOUBLE             dt_;
         GDOUBLE             rho_;
         Elem2D            *elem;
};

#endif
