//************************************************************************************//
// Module       : stokesop.hpp
// Date         : 7/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                the pdV work operator. This weak operator is associated with
//                the following:
//                   (p,Div _v_)
//                The action of the operator is to multiply the
//                interpolated derivative (I2 X D1 or D2 X I1), by the
//                input vector. I1(2) is the interpolation operator,
//                I_ij = h_j(eta_i), where h_j is the basis fcn for
//                v in the 1(2) direction, and eta_i is the 1(2)
//                parent node of p. D1(2)_ij = dh_j(eta_i)/dxi.
//
//                Thus, the operator is actually a weak (integrated)
//                derivative  operator acting on the vector space of
//                the parent domain (the velocity-space), to produce
//                a vector in the subspace (the pressure-space).

//                This (Stokes) operator is somewhat different
//                from the others, in that it is assumed that p and v
//                reside on different grid nodal points within the same
//                element, thus requiring that a complete geometric 
//                description of both field quantities be provided. 
//                
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(PDVOP_HPP)
#define PDVOP_HPP

#include "linop.hpp"
#include "elem2d.hpp"

class StokesOp: public LinOp 
{
public:
                           StokesOp();
                           StokesOp(Elem2D *ve, Elem2D *pe, GINT  idir);
//                         StokesOp(const StokesOp &);
                          ~StokesOp();

         GVector           operator*(GVector) ; // Multiply operator on the RHS by vector
         void              OpVec_prod(GVector &x, GVector &ret);
         void              SetElem(Elem2D *ve, Elem2D *pe);
         void              SetDir(GINT  idir);
         void              SetConst(GDOUBLE c);
         void              Transpose();

//       friend ostream&   operator<<(ostream&, const StokesOp&);

private:
         GBOOL             DefmQuadOp(GVector *x, GVector *newx);
         GBOOL             RectQuadOp(GVector *x, GVector *newx);
         GBOOL             TriangleOp(GVector *x, GVector *newx);
  
         GINT             icomp;
         GSHORT           Np1 ;
         GSHORT           Nv1 ;
         GSHORT           Np2 ;
         GSHORT           Nv2 ;
         GBOOL            bTranspose;
         GDOUBLE          pConst;
         GVector          vtmp;
         Elem2D           *velem;
         Elem2D           *pelem;
};

#endif
