//************************************************************************************//
// Module       : vectorop.hpp
// Date         : 6/4/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                defining a (collocated) vector operator object
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(VECTOROP_HPP)
#define VECTOROP_HPP 

#include "gtvector.hpp"
#include "elem2d.hpp"
#include "gradop.hpp"
#if defined(DO_BLAS_TIMING)
#include "timer.h"
#endif


class VectorOp 
{
public:
                           VectorOp();
                           VectorOp(Elem2D *e, GVector *u1, GVector *u2, GVector *u3, GBOOL doconvect=TRUE);
                          ~VectorOp();

         GVector           Div() ;                                            // Divergence operator                
         void              Div(GVector &ret);
         GVector           Curl(GINT  idir);                                  // Curl operator              
         void              Curl(GINT  idir, GVector &ret);
         GVector           Advect(GVector &c);                               // Advection operator: advects quant. c
         void              Advect(GVector &c,  GVector &ret);
         void              Advect_Weak(GVector &c,  GVector &ret);
         void              Advect(GVector *ui[],  GVector *ret[]);           // Computes u.del u for all u components
         void              AdvectR(GVector *ui[], GVector *N[]);             // Computes rotat'l form of adv, less 0.5*Del(u.u)

         void              SetVec(GVector *u1, GVector *u2, GVector *u3=NULL);
         void              SetElem(Elem2D *e ); 
         void              DoConvectiveForm(GBOOL bflag);

         Elem2D            *GetElem();                                       // Returns base element  

private:

        GBOOL              bConvectiveForm_;
        GVector            *v[3];
        Elem2D             *elem;

#if defined(DO_BLAS_TIMING)
public:
        GDOUBLE            GetTime(){return time_result;}
private:
        GDOUBLE            time_result;
        GDOUBLE            tstart;
#endif

};

#endif
