//************************************************************************************//
// Module       : cg.hpp
// Date         : 9/14/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a conjugate-gradient object.
// Derived From : none.
// Modifications: 7/21/03: converted to linked-list-based data structures
//************************************************************************************//
#if !defined(CG_HPP)
#define CG_HPP

#include "diagop.hpp"
#include "identityop.hpp"
#include "glop.hpp"
#include "gttlist.hpp"
#include "gtlist.hpp"
#include "glinoplist.hpp"
#include "gelemlist.hpp"
#include "gtbuffer.hpp"
#include "gs.hpp"

enum CGType {CG_STANDARD, CG_REDUCED_VAR1, CG_REDUCED_VAR2};  // Types of CG solver algorithm
extern char *s_cgerror_[] ;


class CG 
{
public:
enum              CGERRNO {CGERR_NONE=0    , CGERR_NULLOP  , CGERR_LISTSZERR, 
                           CGERR_BADITERNUM, CGERR_CONVERGE, CGERR_SOLVE   };


                  CG(CGType itype, GBOOL isNested=FALSE);
                  CG(GElemList *e, GLinOpList *A, GLinOpList *ROP, GVecList *x, GVecList *b, GS *comm, 
                     CGType itype=CG_STANDARD, GBOOL isNested=FALSE);
                 ~CG();
                  CG(const CG &a);
void              operator=(const CG &);
void              operator()(GElemList *e, GLinOpList *A, GLinOpList *ROP, GVecList *x, GVecList *b, GS *c) ;

void              Quiet(GBOOL b);
void              SetNoDSS(GVecList *rb);
void              SetTolerance(GDOUBLE);
void              SetMaxIterations(GINT );
void              SetResidualChkNum(GINT );
void              SetSolveType(CGType);
void              SetPreconditioner(GLinOpList *op);
void              SetComm(GS *op);
GCHandle          InitComm(GDWBuffer  *n, GINT  nTotal);
GCHandle          SetCommHandle(GCHandle hIn=NULL);
GCHandle          SetIntermedCommHandle(GCHandle hIn);
void              SetIntermedMask(GLinOpList *in);
void              SetBdyValues (GVecList *bdy_vals);
void              SetElems(GElemList *gelems);
GDOUBLE           GetTolerance();
GINT              GetMaxIterations();
GINT              GetResidualChkNum();
GINT              GetNumIterations();
GDOUBLE           GetError();
GDOUBLE           GetMinError();
GDOUBLE           GetMaxError();
GVector           *GetEucResidualHistory();
GVector           *GetL2ResidualHistory();
GINT              ErrNo();
char              *ErrString();
//GLinOpList      *GetPreconditioner();
GVecList          &GetBdyValues ();

GBOOL             SolveCG();



private:
// Private methods:
GINT              SolveStandard();
GBOOL             OpVec_prod(GVecList &in, GVecList &out);
GINT              SolveReduced(CGType itype);
//GBOOL           DSS_Intermediate(GLinOpList &in_A, GVecList &in_x, GVecList &out_x);
GBOOL             DoDotProducts(GVecList &a1, GVecList a2[], GDOUBLE *ldot, GDOUBLE *dots, const GINT  ndot);
void              ResetExpandables(GLinOpList *AA, GLinOpList *ROp);



// Private data:
GINT              MaxIterations;
GINT              nResidualChk;
GINT              numIterations;
GINT              nIntermedProd;
GINT              iErrType;
GINT              nTotalNodes;
GINT              bad_iter_number;
GINT              nops;
GINT              nprecon;
GBOOL             bQuiet;
GBOOL             bNested;
GBOOL             bMaskAlloc;
CGType            iSolveType;
GDOUBLE    	  tolerance;
GDOUBLE           minErr;
GDOUBLE           maxErr;
GDOUBLE           finErr;
GVector           EucResidual_;
GVector           L2Residual_;
GDWBuffer         *glob_ids;
GDBuffer          *imultiplicity;
GCHandle          hDSOp;
GCHandle          hDSOp_Intermed;
GLinOpList        mask_Intermed;
GS                *gsop;
GElemList         *gelems_;       // element list
GLinOpList        *A;             // operator to be inverted 
GLinOpList        *ROp;           // operator multiplied by b to find RHS
GVecList          *x;             // solution
GVecList          *b;             // RHS operand
GLinOpList        precon;         // preconditioner
GVecList          xb;             // boundary solution
GVecList          bnodss;         // RHS operand contrib which should not be DSS'd
GVecList          intermed_soln;  // intermediate solution for nested case
GVecList          intermed_vecp;  // intermediate vec products pointers for nested case
GVecList          ytmp         ;  // intermediate temp space
GLinOpList        intermed_op;    // list of pointers to intermediate solve's operators
CG                **cg_intermed;  // intermediate solvers, one for each intermed product

// temporary vectors:

GVecList          rk;
GVecList          wk;
GVecList          qk;
GVecList          sk;
GVecList          zk;
GVecList          msk;
GVecList          mqk;
GVecList          vk;

};
#endif

