//************************************************************************************//
// Module       : pcblockjac_lap.hpp
// Date         : 7/17/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a block Jacobi preconditioner object to be used
//                for preconditioning the Laplacian operator
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(PCBLOCKJAC_LAP_HPP)
#define PCBLOCKJAC_LAP_HPP
#include "linop.hpp"
#include "elem2d.hpp"
#include "gnbasis.hpp"

class PCBlockJac_Lap: public LinOp
{
public:
                           PCBlockJac_Lap();
                           PCBlockJac_Lap(LinOp *A);
                           PCBlockJac_Lap(Elem2D *e);
//                         PCBlockJac_Lap(const PCBlockJac_Lap &);
                          ~PCBlockJac_Lap();

         GVector           operator*(GVector) ; // Multiply precond by right-vector
         void              OpVec_prod(GVector &q, GVector &ret);
         void              SetInterpBasis(GNBasis *b1, GNBasis *b2);
         void              SetConst(GDOUBLE clc);
         void              SetConst(GDOUBLE clc1, GDOUBLE iclc2);
         void              SetElem(Elem2D *e);
         void              SetMask(GVector *m);
         GMatrix          *GetInverse() { return iL; }


private:
         GBOOL             DefmQuadL();
         GBOOL             RectQuadL();
         GBOOL             TriangleL();
         GBOOL             ComputeOp();

         GINT              N1;     // 1-size
         GINT              N2;     // 2-size
         GINT              NN;     // 1 X 2 - size
         GDOUBLE             lc1;    // Laplacian-multiplicative constant
         GDOUBLE             lc2;    // Laplacian-multiplicative constant
         Elem2D           *elem;   // Associated element
         GVector          *vtmpv0; // V-space temp vector
         GVector          *vtmpv1; // V-space temp vector
         GVector          *mask  ; // Dirichlet masking vector 
         GMatrix          *L;      // Laplacian operator
         GMatrix          *iL;     // inverse Laplacian
         GMatrix          *I1;     // 1-interpolation operator
         GMatrix          *I2;     // 2-interpolation operator
         GMatrix          *I1T;    // 1-interpolation operator -- transpose
         GMatrix          *I2T;    // 2-interpolation operator -- transpose


};

#endif
