//************************************************************************************//
// Module       : pcblockjac_plap.hpp
// Date         : 1/8/03 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a block Jacobi preconditioner object to be used
//                for preconditioning the pseudo-Laplacian (pressure)
//                operator, 
//                E = D_1 M^-1 D_1^T +  D_2 M^-1 D_2^T + ...
//                The preconditioner simply computes the action of
//                E^-1 on pressure-space vector.
// Derived From : LinOp.
// Modifications:
//************************************************************************************//
#if !defined(PCBLOCKJAC_PLAP_HPP)
#define PCBLOCKJAC_PLAP_HPP
#include "linop.hpp"
#include "schurlapop.hpp"
#include "elem2d.hpp"
#include "gnbasis.hpp"

class PCBlockJac_PLap: public LinOp
{
public:
                           PCBlockJac_PLap();
                           PCBlockJac_PLap(LinOp *A);
                           PCBlockJac_PLap(Elem2D *ve, Elem2D *pe, SchurLapOp *Ein=NULL);
//                         PCBlockJac_PLap(const PCBlockJac_PLap &);
                          ~PCBlockJac_PLap();

         GVector           operator*(GVector) ; // Multiply precond by right-vector
         void              OpVec_prod(GVector &q, GVector &ret);
         void              SetConst(GDOUBLE clc);
         void              SetElem(Elem2D *ve, Elem2D *pe);
         GMatrix          *GetInverse() { return &iL; }
#if 0
         void              SetVBdyData (GINT  idir, GVector *vb, GINT  *indices);
#endif


private:
         GBOOL             ComputeOp();
         GBOOL             DefmQuadL();
         GBOOL             RectQuadL();
         GBOOL             TriangleL();

         GBOOL             bNeed2Compute;
         GBOOL             bDeleteHere;
         GINT              vN1;     // 1-size
         GINT              vN2;     // 2-size
         GINT              vNN;     // 1 X 2 - size
         GINT              pN1;     // 1-size
         GINT              pN2;     // 2-size
         GINT              pNN;     // 1 X 2 - size
         GINT              *ibdy;   // Dirichlet bdy indices
         GDOUBLE           lConst;  // Laplacian-multiplicative constant
         GVector           *vbdy[3];// Dirichlet bdy values for 1- and 2- and 3- derivatives of pressure
         Elem2D            *velem;  // Associated velocity element
         Elem2D            *pelem;  // Associated pressure element
         GMatrix            L;      // Laplacian operator
         GMatrix            iL;     // inverse Laplacian
         GVector            icol;   // column vector
         GVector            rcol;   // row vector
         SchurLapOp        *sop;    // pseudo-Laplacian operator


};

#endif
