//************************************************************************************//
// Module       : bitblock.hpp
// Date         : 3/12/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a bit-block data type
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(BITBLOCK_HPP)
#define BITBLOCK_HPP
#include "gtypes.h"
#include <string.h>
#include <iostream.h>
#include "gtbuffer.hpp"


class BitBlock 
{
public:
                  BitBlock(GINT  Size);
                 ~BitBlock();
                  BitBlock(const BitBlock &a);
BitBlock         &operator=(const BitBlock &);
GUSHORT           operator()(const GINT  bit_posn);
GUSHORT           operator[](const GINT  bit_posn);
friend ostream&   operator<<(ostream&, BitBlock&);

void              SetBits(GINT  bit_index, const GUSHORT  yTo);
//void            SetBits(const GUSHORT  yTo);
GBOOL             SetBlock(GUSHORT  *new_block, GINT  num_subblocks);
GBOOL             SetBlock(GUSHORT  *new_block, GINT  num_subblocks, GINT  size_subblock, GINT  desired_bitspersubblock);
GBOOL             SetBlock(GBuffer<GUSHORT > *new_block, GINT  num_subblocks);
GBOOL             SetBlock(GUSHORT  *hi_block, GUSHORT  *lo_block, GINT  n);
GUSHORT            *GetBlock();
void              *LoWord();
void              *HiWord();
GINT              GetBlockSize_InBits();
GINT              GetBlockSize_InBlocks();
void              Reset();
void              TransferBits(void *in_elems, GINT  nelems, size_t elem_size);


private:
// Private methods:
GUSHORT       getbits_(GUSHORT , int posn, int numbits);
GUSHORT       setbits_(GUSHORT , int posn, int numbits, GUSHORT  y);
// Private data:

GUSHORT            *iBlock;
GINT              BitFieldLength;
GINT              nBits;   
GINT              NumIntSubBlocks;

};
#endif

