//************************************************************************************//
// Module       : gelemlist.cpp
// Date         : 8/9/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple element linked list. This class was taken
//                largely from Algorithms and Data Structures in C++
//                by Ameraal, although it has been recast. 
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "gelemlist.hpp"
#include "defquad2d.hpp"
#include "rectquad2d.hpp"
#include <typeinfo>


//************************************************************************************
//************************************************************************************
// Constructor Method
GElemList::GElemList(GBOOL renumber_on_delete)
:
nid                   (0),
num                   (0),
doRenumber            (renumber_on_delete),
pStart                (NULL),
pCurr                 (NULL),
pEnd                  (NULL)
{

} // end of constructor method


//************************************************************************************
//************************************************************************************
// Destructor
GElemList::~GElemList()
{
  empty();
}

//************************************************************************************
//************************************************************************************
// METHOD     : add (1)
// DESCRIPTION: 
// RETURNS    : add new structure to list, s.t. list owns element pointer
//************************************************************************************
void GElemList::add(ELEMTYPE itype, GINT ntmp)
{
  pCurr        = pEnd;
  pEnd         = new ElemListSt;
  pEnd->id     = nid;
  pEnd->cf     = TRUE;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  switch ( itype ) {
    case  DEFORMED_QUAD:
      pEnd->member = new DefQuad2D (ntmp) ;
      pEnd->type = DEFORMED_QUAD;
      break;
    case  RECT_QUAD:
      pEnd->member = new RectQuad2D (ntmp) ;
      pEnd->type = RECT_QUAD ;
      break;
    case  TRIANGULAR:
    default:
       cout << "GElemList::add (1): invalid element type" << endl;
       exit(1);
  }
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (1)


//************************************************************************************
//************************************************************************************
// METHOD     : add (2)
// DESCRIPTION: 
// RETURNS    : add new structure to list, s.t. list doesn't own element pointer
//************************************************************************************
void GElemList::add(Elem2D *m)
{
  pCurr        = pEnd;
  pEnd         = new ElemListSt;
  pEnd->member = m ;
  pEnd->id     = nid;
  pEnd->cf     = FALSE;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  
  if ( typeid(m) == typeid(DefQuad2D)  ) pEnd->type = DEFORMED_QUAD;
  if ( typeid(m) == typeid(RectQuad2D) ) pEnd->type = RECT_QUAD;
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (2)


//************************************************************************************
//************************************************************************************
// METHOD     : del (1)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
Elem2D *GElemList::del(ElemListSt *e)
{
  Elem2D     *m;
  ElemListSt *next, *prev;

  if ( e == NULL ) {
    cout << "*GElemList::del (0) : attempting to delete a NULL list element" << endl;
    exit(1);
  }
  m    = e->member;
  prev = e->prev;
  next = e->next;

  if ( prev ) prev->next = next;
  if ( next ) next->prev = prev;

  if ( e->cf ) delete e->member;
  delete e;

//(pCurr ? pCurr->next : pStart) = pEnd;
//if ( pCurr  == e )  pCurr  = next ? next : pEnd;
//if ( pStart == e )  pStart = next ? next : pCurr;
  if ( pEnd   == e )  pEnd   = prev;
  if ( pCurr  == e )  pCurr  = next ? next : pEnd;
  if ( pStart == e )  pStart = next ;

  num--;

  if ( doRenumber ) renumber();

  return m;
  
} // end of method del (1)


//************************************************************************************
//************************************************************************************
// METHOD     : del (2)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
Elem2D *GElemList::del(Elem2D *m)
{
  ElemListSt *e;

  if ( !(e=find(m)) ) return NULL;
  
  return del(e);

} // end of method del (2)



//************************************************************************************
//************************************************************************************
// METHOD     : del (3)
// DESCRIPTION:
// RETURNS    : delete structure from list
//************************************************************************************
Elem2D *GElemList::del(GINT  id)
{ 
  ElemListSt *e;
  
  if ( !(e=find(id)) ) return NULL;

  return del(e);

} // end of method del (3)


//************************************************************************************
//************************************************************************************
// METHOD     : size
// DESCRIPTION:
// RETURNS    :  size of list
//************************************************************************************
GINT  GElemList::size() const
{
  return num ;
} // end of method size

#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : start
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
 void GElemList::start(ElemListSt *p = NULL)
{
  pCurr = ( p!=NULL ? p : pStart );
} // end of method start


//************************************************************************************
//************************************************************************************
// METHOD     : member (1)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
Elem2D *GElemList::member()
{
  return pCurr ? pCurr->member : NULL;
} // end of method member (1)


//************************************************************************************
//************************************************************************************
// METHOD     : member (2)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
Elem2D *GElemList::member(GINT  id)
{
  ElemListSt *e;

  if ( (e=find(id)) == NULL ) return NULL;

  return e->member;
} // end of method member (2)


//************************************************************************************
//************************************************************************************
// METHOD     : member (3)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
Elem2D *GElemList::member(GKEY key)
{
  ElemListSt *e;

  if ( (e=find(key)) == NULL ) return NULL;

  return e->member;
} // end of method member (3)


//************************************************************************************
//************************************************************************************
// METHOD     : next
// DESCRIPTION: 
// RETURNS    :  
//************************************************************************************
ElemListSt *GElemList::next()
{
  ElemListSt *p = pCurr ? pCurr->next : NULL;
  pCurr = p;
  return pCurr;
} // end of method next
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : curr
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
ElemListSt *GElemList::curr()
{
  return pCurr;
} // end of method curr


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : find (1)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
ElemListSt *GElemList::find(GINT  id)
{

  ElemListSt *p=pCurr;

  // check from current pointer first:
  if ( p && p->id == id ) return p;
  else if ( p && p->next && p->next->id == id ) {
    next();
    return p->next;
  }


  // start at beginning and search:
  start(NULL);
  while ( (p=curr()) != NULL ) {
    if ( p->id == id ) return p;
    next();
  }
  return NULL;

} // end of method find (1)


//************************************************************************************
//************************************************************************************
// METHOD     : find (2)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
ElemListSt *GElemList::find(Elem2D *member)
{
  ElemListSt *p=pCurr;

  // check from current pointer first:
  if ( p && p->member == member ) return p;
  else if ( p && p->next && p->next->member == member ) { 
     next();
     return p->next;
  }

  // start at beginning and search:
  start(NULL);
  while ( (p=curr()) != NULL ) {
    if ( p->member == member ) return p;
    next();
  }
  return NULL;

} // end of method find (2)


//************************************************************************************
//************************************************************************************
// METHOD     : find (3)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
ElemListSt *GElemList::find(GKEY key)
{

  ElemListSt *p=pCurr;

  // check from current pointer first:
  if ( p && p->member->GetID() == key ) return p;
  else if ( p && p->next && p->next->member->GetID() == key ) {
    next();
    return p->next;
  }


  // start at beginning and search:
  start(NULL);
  while ( (p=curr()) != NULL ) {
    if ( p->member->GetID() == key ) return p;
    next();
  }
  return NULL;

} // end of method find (3)
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : X
// DESCRIPTION: Get X-coordinate vector, for element iElem, specified by idir parameter
// ARGUMENTS  : 
// 
// RETURNS    :
//************************************************************************************
GVector *GElemList::X(const GINT  iElem, const GINT  idir)
{
  Elem2D *e;
  
  if ( (e=member(iElem)) == NULL ) {
    cout << "GElemList::X: Cannot access element " << iElem << endl;
    exit(1);
  } 
  
  return e->GetSpNodes(idir);
  
} // end of method X



//************************************************************************************
//************************************************************************************
// METHOD     : X
// DESCRIPTION: Get X-coordinate, for element iElem, specified by idir parameter,
//              at coord index i
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
GDOUBLE &GElemList::X(const GINT  iElem, const GINT  idir, const GINT  i)
{
  Elem2D *e;

  if ( (e=member(iElem)) == NULL ) {
    cout << "GElemList::X: Cannot access element " << iElem << endl;
    exit(1);
  }

  return *(e->GetSpNodes(idir)->Data()+i);

} // end of method X


//************************************************************************************
//************************************************************************************
// METHOD     : dim 
// DESCRIPTION: Get idir-dimension for element iElem
// ARGUMENTS  :
// 
// RETURNS    :
//************************************************************************************
GINT  GElemList::dim(const GINT  iElem, const GINT  idir)
{ 
  Elem2D *e;

  
  if ( (e=member(iElem)) == NULL ) { 
    cout << "GElemList::dim: Cannot access element " << iElem << endl;
    exit(1);
  }
  
  return e->GetSpNodes(idir)->dim();

} // end of method dim


//************************************************************************************
//************************************************************************************
// METHOD     : renumber
// DESCRIPTION:
// RETURNS    : Renumber ids consecutively, used mainly after a delete
//************************************************************************************
GBOOL GElemList::renumber()
{
  GINT      i=0;
  ElemListSt *p, *pkeep=curr();

  start(NULL);
  while ( (p=curr()) != NULL ) {
    p->id = i;
    next();
    i++;
  }
  nid = i;
//start(NULL);
  return TRUE;
} // end of method renumber


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : operator() (1)
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
Elem2D *&GElemList::operator()(const GINT  iElem)
{
  ElemListSt *tt;

  if ( (tt=find(iElem)) == NULL ) {
    cout << "GElemList::operator(): Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member ;

} // end of method operator ()  (1)


//************************************************************************************
//************************************************************************************
// METHOD     : operator[] (1)
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
Elem2D *&GElemList::operator[](const GINT  iElem)
{
  ElemListSt *tt;

  if ( (tt=find(iElem)) == NULL ) {
    cout << "GElemList::operator[]: Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member ;

} // end of method operator []  (1)
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : empty
// DESCRIPTION:
// RETURNS    : delete list data
//************************************************************************************
void GElemList::empty()
{
  ElemListSt *dcurr, *dnext;
  
  dcurr = pStart;
  while ( dcurr ) { 
    dnext = dcurr->next;
    del (dcurr);
    dcurr = dnext;
  }    
  pStart = pEnd = pCurr = NULL;
  num = nid = 0;

} // end of method empty


//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (1)
// DESCRIPTION:
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
ostream &operator<<(ostream &str, GElemList &a)
{

  GINT  n=0;
  ElemListSt *es;

  a.start(NULL);
  while ( a.member() && n < a.size() ) {
    es = a.curr();
    if ( a.member() && es ) {
      str << "member[" << es->id << "]=" << *(a.member()) << endl;
    }
    a.next();
    n++;
  }
  a.start(NULL);

  return str;
} // end of << operator(1)

