//************************************************************************************//
// Module       : gelemlist.hpp
// Date         : 8/9/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple element linked list. This class was taken
//                largely from Algorithms and Data Structures in C++
//                by Ameraal, although it has been recast. 
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GELEMLIST_HPP)
#define GELEMLIST_HPP

#include "gtypes.h"
#include "rectquad2d.hpp"
#include "defquad2d.hpp"
#include <iostream.h>
#include <stdlib.h>

#if !defined(GELEMLIST_MEM)
#define GELEMLIST_MEM
struct ElemListSt {
GINT       id;       // Key id
GBOOL      cf;       // Was member fully instantiated?
Elem2D     *member;  // Member data
ELEMTYPE   type;     // Element type id
ElemListSt *next;    // Next in list
ElemListSt *prev;    // Previous in list
}; 
#endif

class GElemList
{

public:
                           GElemList(GBOOL renumber_on_delete=FALSE);
                           GElemList(const GElemList &);
                          ~GElemList();

         void             add(ELEMTYPE itype, GINT ntmp);
         void             add(Elem2D *c);
         Elem2D           *del(ElemListSt *c);
         Elem2D           *del(Elem2D *c);
         Elem2D           *del(GINT  id);
inline   void             start(ElemListSt *p=NULL) {
           pCurr = ( p!=NULL ? p : pStart );
         }
         GINT             size() const;
inline   Elem2D           *member() {
           return pCurr ? pCurr->member : NULL;
         }
inline   Elem2D           *member(GINT  id) {
           ElemListSt *e;
           if ( (e=find(id)) == NULL ) return NULL;
           return e->member;
         }
inline   Elem2D           *member(GKEY key) {
           ElemListSt *e;
           if ( (e=find(key)) == NULL ) return NULL;
           return e->member;
         }
inline   ElemListSt       *next() {
           ElemListSt *p = pCurr ? pCurr->next : NULL;
           pCurr = p; return pCurr;
         }
         ElemListSt       *curr();
inline   ElemListSt       *find(GINT  id) {
           ElemListSt *p=pCurr;
           // check from current pointer first:
           if ( p && p->id == id ) return p;
           else if ( p && p->next && p->next->id == id ) {
             next();
             return p->next;
           }
           start(NULL); // start at beginning and search:
           while ( (p=curr()) != NULL ) {
             if ( p->id == id ) return p;
             next();
           }
           return NULL;
         }
inline   ElemListSt       *find(Elem2D *member) {
           ElemListSt *p=pCurr;
           // check from current pointer first:
           if ( p && p->member == member ) return p;
           else if ( p && p->next && p->next->member == member ) { 
              next();
              return p->next;
           }
           start(NULL); // start at beginning and search:
           while ( (p=curr()) != NULL ) {
             if ( p->member == member ) return p;
             next();
           }
           return NULL;
         }
inline   ElemListSt       *find(GKEY key) {
           ElemListSt *p=pCurr;
           // check from current pointer first:
           if ( p && p->member->GetID() == key ) return p;
           else if ( p && p->next && p->next->member->GetID() == key ) {
             next();
             return p->next;
           }
           start(NULL); // start at beginning and search:
           while ( (p=curr()) != NULL ) {
             if ( p->member->GetID() == key ) return p;
             next();
           }
           return NULL;
         }
         GVector          *X (const GINT  iElem, const GINT  idir);
         GDOUBLE            &X (const GINT  iElem, const GINT  idir, const GINT  i);
         GINT             dim(const GINT  iElem, const GINT  idir);
         GBOOL            renumber();
         void             empty();
inline   Elem2D           *&operator()(const GINT  iElem) {
           ElemListSt *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem);
#else
           if ( (tt=find(iElem)) == NULL ) {
             cout << "GElemList::operator(): Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member ;
         }
inline   Elem2D           *&operator[](const GINT  iElem) {
           ElemListSt *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem); 
#else
           if ( (tt=find(iElem)) == NULL ) {
             cout << "GElemList::operator[]: Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member ;
         }
         friend ostream&  operator<<(ostream&, GElemList&);



private:
// Private methods:
// Private data:
        GINT               nid;
        GINT               num;
        GBOOL              doRenumber;
        ElemListSt        *pStart;
        ElemListSt        *pCurr;
        ElemListSt        *pEnd;

};
#endif

