//************************************************************************************
// Module       : gexlib.cpp
// Date         : 5/14/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Namespace encapsulating general external library
//                (shared object) access utilities.
// Derived From : none.
// Modifications:
//************************************************************************************
#include "gexlib.hpp"
#include <dlfcn.h>

//************************************************************************************
//************************************************************************************
// METHOD     : so_open
// DESCRIPTION: Opens shared object (dynamic lib), returning a handle
// ARGUMENTS  : char * lib name
// RETURNS    : handle on success; else NULL
//************************************************************************************
SOHANDLE GExLib::so_open(const char *libname, int flag)
{
#if defined(_LINUX)
  return dlopen(libname,flag);
#endif
  return SOHANDLE_NULL;
} // end of so_open

//************************************************************************************
//************************************************************************************
// METHOD     : so_close
// DESCRIPTION: Closes shared library
// ARGUMENTS  : SOHANDLE handle: corresponding to open dynamic lib.
// RETURNS    : none.
//************************************************************************************
void  GExLib::so_close(SOHANDLE handle)
{
#if defined(_LINUX)
  dlclose(handle);
#endif
} // end of so_close

//************************************************************************************
//************************************************************************************
// METHOD     : so_sym
// DESCRIPTION: Returns address of symbol 'symbol' in the dynamic lib whose
//              handle is 'handle'.
//
// ARGUMENTS  : SOHANDLE handle : handle of opened dynamic lib.
//              char *  symbol  : symbol name of entry point
// RETURNS    : address on success; else NULL
//************************************************************************************
SYMADDRESS  GExLib::so_sym(SOHANDLE handle, const char *symbol)
{
#if defined(_LINUX)
  return dlsym(handle, symbol);
#endif
  return SOHANDLE_NULL;
} // end of so_sym

//************************************************************************************
//************************************************************************************
// METHOD     : so_erro
// DESCRIPTION: Gets error string for most recent dynamic lib  transaction
// ARGUMENTS  : none
// RETURNS    : char * string
//************************************************************************************
const char *GExLib::so_error()
{
#if defined(_LINUX)
  return dlerror();
#endif
  return SOHANDLE_NULL;
} // end of so_error


