//************************************************************************************
// Module       : gexlib.hpp
// Date         : 5/14/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Namespace encapsulating general external library
//                (shared object) access utilities.
// Derived From : none.
// Modifications:
//************************************************************************************
#if !defined(GEXLIB_HPP)
#define GEXLIB_HPP

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include <unistd.h>


// Defines:
#define SOHANDLE        void *
#define SOHANDLE_NULL   NULL
#define SYMADDRESS      void *
#if defined(_LINUX)
#define SOHANDLE        void *
#define SYMADDRESS      void *
#endif

namespace GExLib
{

  SOHANDLE     so_open(const char *filename, int flag);
  void         so_close(SOHANDLE);
  SYMADDRESS   so_sym (SOHANDLE handle, const char *filename);
  const char  *so_error(void);
}

#endif

