//************************************************************************************//
// Module       : gfieldlist.hpp
// Date         : 9/24/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple field linked list. This class was taken
//                largely from Algorithms and Data Structures in C++
//                by Ameraal, although it has been recast. 
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GFIELDLIST_HPP)
#define GFIELDLIST_HPP

#include "gtypes.h"
#include "field2d.hpp"
#include <iostream.h>
#include <stdlib.h>

#if !defined(GFIELDLIST_MEM)
#define GFIELDLIST_MEM
struct FieldListSt {
GINT       id;        // Key id
GBOOL      cf;        // Was member fully instantiated?
Field2D    *member;   // Member data
FieldListSt *next;    // Next in list
FieldListSt *prev;    // Previous in list
}; 
#endif



class GFieldList
{

public:
                          GFieldList(GBOOL renumber_on_delete=FALSE);
                          GFieldList(const GFieldList &);
                         ~GFieldList();

         void             operator=(const GDOUBLE a);
         void             operator=(GFieldList &v);
         void             SetTimeLevel(GINT ilevel);

         void             add(const GINT  NTimeLevels, Elem2D *e, GSHORT ntmp=2);
         void             add(Field2D *c);
         Field2D          *del(FieldListSt *c);
         Field2D          *del(Field2D *c);
         Field2D          *del(Elem2D *e);
         Field2D          *del(GINT  id);
inline   void             start(FieldListSt *p=NULL) {
           pCurr = ( p!=NULL ? p : pStart );
         }
         GINT             size() const;
inline   Field2D          *member() {
           return pCurr ? pCurr->member : NULL;
         }
inline   Field2D          *member(GINT  id) {
           FieldListSt *e;
           if ( (e=find(id)) == NULL ) return NULL;
           return e->member;
         }
inline   FieldListSt      *next() {
           FieldListSt *p = pCurr ? pCurr->next : NULL;
           pCurr = p; return pCurr;
         }
         FieldListSt      *curr();
inline   FieldListSt      *find(GINT  id) { FieldListSt *p=pCurr;
           if ( p && p->id == id ) return p;
           else if ( p && p->next && p->next->id == id ) {
             next(); return p->next; }
           start(NULL);
           while ( (p=curr()) != NULL ) {
             if ( p->id == id ) return p; next(); }
           return NULL; }
inline   FieldListSt      *find(Field2D *f) { FieldListSt *p=pCurr;
           if ( p && p->member == f ) return p;
           else if ( p && p->next && p->next->member == f ) { 
              next(); return p->next; }
           start(NULL);
           while ( (p=curr()) != NULL ) {
             if ( p->member == f ) return p; next(); }
           return NULL; }
         FieldListSt      *find(Elem2D *);
         GDOUBLE           &operator()(const GSHORT nLevel, const GINT iElem, const GINT  i);
         GDOUBLE           &operator()(const GINT iElem, const GINT i);
         GVector          *X (const GINT iElem, const GSHORT  idir);
         GDOUBLE           &X (const GINT iElem, const GSHORT  idir, const GINT i);
         GINT             dim(const GINT iElem, const GSHORT  idir);
         GBOOL            renumber();
         void             empty();
inline   Field2D          *&operator()(const GINT  iElem) {
           FieldListSt *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem);
#else
           if ( (tt=find(iElem)) == NULL ) {
             cout << "GFieldList::operator(): Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member ;
         }
inline   Field2D          *&operator[](const GINT  iElem) {
           FieldListSt *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem);
#else
           if ( (tt=find(iElem)) == NULL ) {
             cout << "GFieldList::operator[]: Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member ;
         }
         friend ostream&  operator<<(ostream&, GFieldList &);

private:
// Private methods

// Private data:
        GINT               nid;
        GINT               num;
        GINT               iLevel_;
        GBOOL              doRenumber;
        FieldListSt        *pStart;
        FieldListSt        *pCurr;
        FieldListSt        *pEnd;

};
#endif

