//************************************************************************************//
// Module       : glinoplist.hpp
// Date         : 7/17/03 (DLR)
// Copyright    : 2003-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple LinOp linked list. This class was taken
//                largely from Algorithms and Data Structures in C++
//                by Ameraal, although it has been recast.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GLINOPLIST_HPP)
#define GLINOPLIST_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "linop.hpp"



#if !defined(GLINOPELEM)
#define GLINOPELEM
class GLinOpElem {
public:
GINT      id;
GBOOL     cf;
LinOp     *member;
GLinOpElem *next;
GLinOpElem *prev;
}; 
#endif


class GLinOpList
{
public:
                          GLinOpList(GBOOL renumber_on_delete=FALSE);
                          GLinOpList(GINT  nelems, GBOOL renumber_on_delete=FALSE);
                          GLinOpList(const GLinOpList &){};
                         ~GLinOpList();

         void             add(LinOp *c, GBOOL delete_here=TRUE);
         LinOp            *del(GLinOpElem *c);
         LinOp            *del(LinOp *c);
         LinOp            *del(GINT  id);
inline   void             start(GLinOpElem *p=NULL) {
           pCurr = ( p!=NULL ? p : pStart );
         }
         GINT             size() ;
inline   LinOp            *member() {
           return pCurr ? pCurr->member : NULL;
         }
         LinOp            *member(GINT  id) {
           GLinOpElem *e;
           if ( (e=find(id)) == NULL ) return NULL;
           return e->member;
         }
inline   GLinOpElem       *next() {
           GLinOpElem *p = pCurr ? pCurr->next : NULL;
           pCurr = p; return pCurr;
         }
         GLinOpElem       *curr();
inline   GLinOpElem       *find(GINT  id) {
           GLinOpElem *p=pCurr;
           // check from current pointer first:
           if ( p && p->id == id ) return p;
           else if ( p && p->next && p->next->id == id ) {
              next();
              return p->next;
           }
           start(NULL); // start at beginning and search:
           while ( (p=curr()) != NULL ) { 
             if ( p->id == id ) return p;
             next();
           }
           return NULL;
         }
inline   GLinOpElem       *find(LinOp *member) {
           GLinOpElem *p=pCurr;
           // check from current pointer first:
           if ( p && p->member == member ) return p; 
           else if ( p && p->next && p->next->member == member ) {
             next();
             return p->next;
           }
           start(NULL); // start at beginning and search:
           while ( (p=curr()) != NULL ) {
             if ( p->member == member ) return p;
             next();
           }
           return NULL;
         }
inline   LinOp            *&operator()(const GINT  iElem) {
           GLinOpElem  *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem);
#else
           if ( (tt=find(iElem)) == NULL ) {
             cout << "GTTList::operator(): Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member;
         }
inline   LinOp            *&operator[](const GINT  iElem) {
           GLinOpElem  *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem);
#else
           if ( (tt=find(iElem)) == NULL ) {
             cout << "GTTList::operator[]: Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member;
         }
         GBOOL            renumber();
         void             empty();
//       friend ostream&  operator<<(ostream&, GLinOpList&);

private:
// Private methods:



// Private data:
        GINT               nid;
        GINT               num;
        GBOOL              doRenumber;
        GLinOpElem         *pStart;
        GLinOpElem         *pCurr;
        GLinOpElem         *pEnd;

};
#endif

