//************************************************************************************//
// Module       : glogger.hpp
// Date         : 12/11/04 (DLR)
// Copyright    : 2004-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a logging class as used in GASpAR
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GLOGGER_HPP)
#define GLOGGER_HPP

#include "gtlist.hpp"
#include <iostream.h>
#include <fstream.h>
#include <cstdarg>


class GLogger 
{
public:
                  GLogger();
                 ~GLogger();
                  GLogger(const GLogger &a);

GBOOL             SetStaticParamDesc (char *format, ...);                          // set static param descriptors
GBOOL             SetDynamicParamDesc (char *format, ...);                         // set dynamic param descriptors
GBOOL             SetStaticData      (GINT nflds, ...);                            // set static data fields
GBOOL             SetDynamicData     (GINT nflds, ...);                            // set dynamic record fields
GBOOL             PutStaticData      (char *filename);                             // write static data to file
GBOOL             PutStaticData      (ostream  &out);                              // write static data to stream
GBOOL             PutHeader          (char *filename);                             // build and write dyn header to file
GBOOL             PutHeader          (ostream  &out);                              // build and write dyn header to stream
GBOOL             PutDynamicData     (char *filename);                             // build and write dyn record to file
GBOOL             PutDynamicData     (ostream  &out);                              // build and write dyn record to stream

private:
// Private methods:
GBOOL             SetParams(GStringList &flist, GStringList &dlist, char *format, va_list ap);
GBOOL             SetData(GINT nfields, GpCList &plist, va_list ap);


 

// Private data:
GStringList sstaticdesc_;                          // static descriptors
GStringList sdynamicdesc_;                         // dynamic descriptors
GStringList sstaticformat_;                        // static format specs
GStringList sdynamicformat_;                       // dynamic format specs
GpCList     pstaticdata_;                          // static data pointer list
GpCList     pdynamicdata_;                         // dynamic data pointer list

};
#endif

