//************************************************************************************//
// Module       : gmemmgr.hpp
// Date         : 10/11/04 (DLR)
// Copyright    : 2004-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a GASpAR element-based memory manager. This class provides
//                access to temp space allocated to be the size of the element member
//                data's data segment size by default. A new vector memory space when
//                allocated, is wrapped by a semaphore so that it cannot be accessed
//                again, until the memory space is made available again. This is
//                accomplished by a call to the method Unlock.
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GMEMMGR_HPP)
#define GMEMMGR_HPP

#include "gttlist.hpp"


class GMemMgr 
{
public:
                  GMemMgr(GINT numvecs=1);
                 ~GMemMgr();
                  GMemMgr(const GMemMgr &a);

GBOOL             Lock(GVector *v);                                // lock a vector
GBOOL             Unlock(GVector *v);                              // unlock a vector
void              Delete(GVector *v);                              // delete memory area
void              Delete(GINT i);                                  // delete memory area
GBOOL             GetGVec(GVector *&vec);                          // get a vector
GVector           *GetGVec(GINT i);                                // get a specific vector from list
GINT              GetFirstAvail();                                 // get 1st available specific index
GINT              GetIndex(GVector *&vec);                         // get index of specified temp vector
GBOOL             AddBlocks(GINT n);                               // add n new blocks to mgr
void              SetSize(GINT n);                                 // set memory block sizes
GINT              GetNumBlocks();                                  // get current num of mem. blocks (vectors)



private:
// Private methods:
 

// Private data:
GINT              NN_;                             // size of data blocks (vectors)
GVecList          vlocked_;                        // locked vector indices
GVecList          gveclist_ ;                      // list of available vectors

};
#endif

