//************************************************************************************//
// Module       : gobjbuffer.hpp
// Date         : 7/9/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a buffer template object holding GASpAR objects
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GOBJBUFFER_HPP)
#define GOBJBUFFER_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "gllbasis.hpp"
#include "glbasis.hpp"


#if !defined(CHBuffer)
#  define CHBuffer  GObjBuffer<CHandle>
#endif


template<class TBUFF> class GObjBuffer
{


private:

// Private methods:
        void              DeleteDynamic();

// Private data:
        GINT               n;
        TBUFF             *data;


public:
                           GObjBuffer();
                           GObjBuffer(GINT  size);
                           GObjBuffer(const GObjBuffer &);
//virtual                 ~GObjBuffer();
                          ~GObjBuffer();


#if 0
         void              operator=(GObjBuffer<TBUFF> &);
         void              operator=(TBUFF *m);
#endif
inline    TBUFF            &operator()(const GINT  i) { 
#if defined(GARRAY_BOUNDS)
                            if ( i >= n || i < 0 ) {
                              cout << "GObjBuffer<T>::(): access error: index=" << i << "; max=" <<  n << endl;
                              exit(1);
                             }
#endif
                            return data[i]; }
inline    TBUFF            &operator[](const GINT  i) const {
#if defined(GARRAY_BOUNDS)
                            if ( i >= n || i < 0 ) {
                              cout << "GObjBuffer<T>::[]: access error: index=" << i << "; max=" <<  n << endl;
                              exit(1);
                             }
#endif
                            return data[i]; } 
#if 0
         friend ostream&   operator<<(ostream &, const GObjBuffer<TBUFF> &);
#endif
                   
         GINT              dim() const;
         TBUFF            *Data();
         GBOOL             Resize(GINT  order);

};
#if defined(_LINUX) || defined(_AIX)
template class GObjBuffer<CHandle>;
ostream &operator <<(ostream&, const GObjBuffer<CHandle>&);
#endif
#endif
