//************************************************************************************//
// Module       : gobjlist.cpp
// Date         : 8/9/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple object-template linked list. This class was taken
//                largely from Algorithms and Data Structures in C++
//                by Ameraal, although it has been recast as a template
//                class.
// Derived From : none.
// Modifications:
//************************************************************************************//
#include "gobjlist.hpp"


//************************************************************************************
//************************************************************************************
// Constructor Method
template<class TT> GObjList<TT>::GObjList<TT>(GBOOL renumber_on_delete)
:
nid                   (0),
num                   (0),
doRenumber            (renumber_on_delete),
pStart                (NULL),
pCurr                 (NULL),
pEnd                  (NULL)
{

} // end of constructor method


//************************************************************************************
//************************************************************************************
// Constructor Method (2)
template<class TT> GObjList<TT>::GObjList<TT>(GINT  nelems, GBOOL renumber_on_delete)
:
nid                   (0),
num                   (0),
doRenumber            (renumber_on_delete),
pStart                (NULL),
pCurr                 (NULL),
pEnd                  (NULL)
{   
  GINT  i;

  for ( i=0; i<nelems; i++ ) {
    add(NULL,TRUE);
  }
    
} // end of constructor method (2)


//************************************************************************************
//************************************************************************************
// Destructor
template<class TT> GObjList<TT>::~GObjList<TT>()
{
  empty();
}

//************************************************************************************
//************************************************************************************
// METHOD     : add (1)
// DESCRIPTION: 
// RETURNS    : add new structure to list
//************************************************************************************
template<class TT> void GObjList<TT>::add()
{
  pCurr        = pEnd;
  pEnd         = new ObjLinkElem;
  pEnd->member = new TT () ;
  pEnd->id     = nid;
  pEnd->cf     = TRUE;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (1)


//************************************************************************************
//************************************************************************************
// METHOD     : add (2)
// DESCRIPTION: 
// RETURNS    : add new structure to list
//************************************************************************************
template<class TT> void GObjList<TT>::add(TT *m, GBOOL del_here)
{
  pCurr        = pEnd;
  pEnd         = new ObjLinkElem;
  pEnd->member = m ;
  pEnd->id     = nid;
  pEnd->cf     = del_here;
  pEnd->next   = NULL;
  pEnd->prev   = pCurr;
  (pCurr ? pCurr->next : pStart) = pEnd;
//next();
  pCurr = pEnd;

  nid++;
  num++;
} // end of method add (2)


//************************************************************************************
//************************************************************************************
// METHOD     : del (0)
// DESCRIPTION:
// RETURNS    : delete structure from list. Do a renumbering of ids if 
//              set to do so on construction.
//************************************************************************************
template<class TT> TT *GObjList<TT>::del(ObjLinkElem *e)
{
  TT          *m;
  ObjLinkElem *next, *prev;

  if ( e == NULL ) {
    cout << "template<class TT> TT *GObjList<TT>::del (0) : attempting to delete a NULL list element" << endl;
    exit(1);
  }

  m    = e->member;
  prev = e->prev;
  next = e->next;

  if ( prev ) prev->next = next;
  if ( next ) next->prev = prev;

  if ( e->cf ) delete e->member;
  delete e;

//(pCurr ? pCurr->next : pStart) = pEnd;
//if ( pCurr  == e )  pCurr  = next ? next : pEnd;
  if ( pEnd   == e )  pEnd   = prev;
  if ( pCurr  == e )  pCurr  = next ? next : pEnd;
  if ( pStart == e )  pStart = next ? next : pCurr;

  num--;

  if ( doRenumber ) renumber();

  return m;
  
} // end of method del (0)



//************************************************************************************
//************************************************************************************
// METHOD     : del (1)
// DESCRIPTION:
// RETURNS    : delete structure from list. Do a renumbering of ids if
//              set to do so on construction.
//************************************************************************************
template<class TT> TT *GObjList<TT>::del(TT *m)
{
  ObjLinkElem *e;

  if ( !(e=find(m)) ) return NULL;

  return del(e);
 

} // end of method del (1)



//************************************************************************************
//************************************************************************************
// METHOD     : del (2)
// DESCRIPTION:
// RETURNS    : delete structure from list. Do a renumbering of ids if
//              set to do so on construction.
//************************************************************************************
template<class TT> TT *GObjList<TT>::del(GINT  id)
{ 
  ObjLinkElem *e;
  
  if ( !(e=find(id)) ) return NULL;

  return del(e);
 
} // end of method del (2)


//************************************************************************************
//************************************************************************************
// METHOD     : size
// DESCRIPTION:
// RETURNS    :  size of list
//************************************************************************************
template<class TT> GINT  GObjList<TT>::size() 
{
  return num ;
} // end of method size


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : start
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TT> void GObjList<TT>::start(ObjLinkElem *p)
{
  pCurr = ( p!=NULL ? p : pStart );
} // end of method start


//************************************************************************************
//************************************************************************************
// METHOD     : member (1)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TT> TT *GObjList<TT>::member()
{
  return pCurr ? pCurr->member : NULL;
} // end of method member (1)


//************************************************************************************
//************************************************************************************
// METHOD     : member (2)
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TT> TT *GObjList<TT>::member(GINT  id)
{
  ObjLinkElem *e;

  if ( (e=find(id)) == NULL ) return NULL;

  return e->member;
} // end of method member (2)


//************************************************************************************
//************************************************************************************
// METHOD     : next
// DESCRIPTION: 
// RETURNS    :  
//************************************************************************************
template<class TT> ObjLinkElem *GObjList<TT>::next()
{
  ObjLinkElem *p = pCurr ? pCurr->next : NULL;
  pCurr = p;
  return pCurr;
} // end of method next
#endif


//************************************************************************************
//************************************************************************************
// METHOD     : curr
// DESCRIPTION:
// RETURNS    :
//************************************************************************************
template<class TT> ObjLinkElem *GObjList<TT>::curr()
{
  return pCurr;
} // end of method curr


#if 0
//************************************************************************************
//************************************************************************************
// METHOD     : find (1)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
template<class TT> ObjLinkElem *GObjList<TT>::find(GINT  id)
{

  ObjLinkElem *p=pCurr;

  // check from current pointer first:
  if ( p && p->id == id ) return p;
  else if ( p && p->next && p->next->id == id ) {
    next();
    return p->next;
  }

  // start at beginning and search:
  start();
  while ( (p=curr()) != NULL ) {
    if ( p->id == id ) return p;
    next();
  }
  return NULL;

} // end of method find (1)


//************************************************************************************
//************************************************************************************
// METHOD     : find (2)
// DESCRIPTION: 
// RETURNS    : 
//************************************************************************************
template<class TT> ObjLinkElem *GObjList<TT>::find(TT *member)
{

  ObjLinkElem *p=pCurr;

  // check from current pointer first:
  if ( p && p->member == member ) return p;
  else if ( p && p->next && p->next->member == member ) { 
     next();
     return p->next;
  }

  // start at beginning and search:
  start();
  while ( (p=curr()) != NULL ) {
    if ( p->member == member ) return p;
    next();
  }
  return NULL;

} // end of method find (2)


//************************************************************************************
//************************************************************************************
// METHOD     : operator()
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
template<class TT> TT *&GObjList<TT>::operator()(const GINT  iElem)
{
  ObjLinkElem *tt;

  if ( (tt=find(iElem)) == NULL ) {
    cout << "GObjList::operator(): Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member;
 
} // end of method operator ()


//************************************************************************************
//************************************************************************************
// METHOD     : operator[]
// DESCRIPTION: Member field access method
// ARGUMENTS  :
//
// RETURNS    :
//************************************************************************************
template<class TT> TT *&GObjList<TT>::operator[](const GINT  iElem)
{
  ObjLinkElem *tt;

  if ( (tt=find(iElem)) == NULL ) {
    cout << "GObjList::operator[]: Cannot access element " << iElem << endl;
    exit(1);
  }

  return tt->member;

} // end of method operator[]
#endif



//************************************************************************************
//************************************************************************************
// METHOD     : renumber
// DESCRIPTION:
// RETURNS    : Renumber ids consecutively, used mainly after a delete
//************************************************************************************
template<class TT> GBOOL GObjList<TT>::renumber()
{
  GINT        i=0;
  ObjLinkElem *p, *pkeep=curr();

  start(NULL);
  while ( (p=curr()) != NULL ) {
    p->id = i;
    next();
    i++;
  }
  nid = i;
  start(NULL);
  return TRUE;
} // end of method renumber

//************************************************************************************
//************************************************************************************
// METHOD     : empty
// DESCRIPTION:
// RETURNS    : delete list data
//************************************************************************************
template<class TT> void GObjList<TT>::empty()
{
  while ( pStart ) {
    pCurr = pStart;
    pStart = pStart->next;
    del (pCurr->id);
  }
  pStart = pEnd = pCurr = NULL;
  num = nid = 0;

} // end of method empty


//************************************************************************************
//************************************************************************************
// METHOD     :  << operator method (1)
// DESCRIPTION:
// ARGUMENTS  :
//
// RETURNS    :  
//************************************************************************************
template<class TT> ostream &operator<<(ostream &str, GObjList<TT> &a)
{

  GINT  i=0;  

  str << endl;
  a.start(NULL);
  while ( a.member() && i < a.size() ) {
    str << "member[" << i << "]=" << *(a.member()) << endl;
    a.next();
    i++;
  }
  a.start(NULL);
    
  return str;
} // end of << operator(1)
  
