//************************************************************************************
// Module       : gobjlist.hpp
// Date         : 8/9/02 (DLR)
// Copyright    : 2002-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a simple object template linked list. This class was taken
//                largely from Algorithms and Data Structures in C++
//                by Ameraal, although it has been recast as a template
//                class.
// Derived From : none.
// Modifications:
//************************************************************************************
#if !defined(GOBJLIST_HPP)
#define GOBJLIST_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "vectorop.hpp"
#include "gfieldgroup.hpp"
#include "gllbasis.hpp"
#include "glbasis.hpp"

#if !defined(GVecOpList)
#  define GVecOpList GObjList<VectorOp>
#endif

#if !defined(GFGList)
#  define GFGList GObjList<GFieldGroup>
#endif

#if !defined(OBJLINKELEMT)
#define OBJLINKELEMT
#define ObjLinkElem LinkElemObj<TT>
template<class TT> class LinkElemObj {
public:
GINT        id;
GBOOL       cf;
TT          *member;
ObjLinkElem *next;
ObjLinkElem *prev;
}; 
#endif


template <class TT> class GObjList
{

public:
                          GObjList(GBOOL renumber_on_delete=FALSE);
                          GObjList(GINT  nelems, GBOOL renumber_on_delete=FALSE);
                          GObjList(const GObjList &);
                         ~GObjList();

         void             add();
         void             add(TT *c, GBOOL delete_here=FALSE);
         TT               *del(ObjLinkElem *c);
         TT               *del(TT *c);
         TT               *del(GINT  id);
inline   void             start(ObjLinkElem *p=NULL) {
           pCurr = ( p!=NULL ? p : pStart );
         }
         GINT             size() ;
inline   TT               *member() {
           return pCurr ? pCurr->member : NULL;
         }
inline   TT               *member(GINT  id) {
           ObjLinkElem *e;
           if ( (e=find(id)) == NULL ) return NULL;
           return e->member;
         }
inline   ObjLinkElem      *next() {
           ObjLinkElem *p = pCurr ? pCurr->next : NULL;
           pCurr = p;
           return pCurr;
         }
         ObjLinkElem      *curr();
inline   ObjLinkElem      *find(GINT  id) {
           ObjLinkElem *p=pCurr;
           // check from current pointer first:
           if ( p && p->id == id ) return p;
           else if ( p && p->next && p->next->id == id ) {
             next();
             return p->next;
           }
           start(); // start at beginning and search:
           while ( (p=curr()) != NULL ) {
             if ( p->id == id ) return p;
             next();
           }
           return NULL;
         }
inline   ObjLinkElem      *find(TT *member) {
           ObjLinkElem *p=pCurr;
           // check from current pointer first:
           if ( p && p->member == member ) return p;
           else if ( p && p->next && p->next->member == member ) {
              next();
              return p->next;
           }
           start(); // start at beginning and search:
           while ( (p=curr()) != NULL ) {
             if ( p->member == member ) return p;
             next();
           }
           return NULL;
         }
inline   TT               *&operator()(const GINT  iElem) {
           ObjLinkElem *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem);
#else
           if ( (tt=find(iElem)) == NULL ) {
             cout << "GObjList::operator(): Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member;
         }
inline   TT               *&operator[](const GINT  iElem) {
           ObjLinkElem *tt;
#if !defined(GLIST_BOUNDS)
           tt=find(iElem);
#else
           if ( (tt=find(iElem)) == NULL ) {
             cout << "GObjList::operator[]: Cannot access element " << iElem << endl;
             exit(1);
           }
#endif
           return tt->member;
         }
         GBOOL            renumber();
         void             empty();

         friend ostream&  operator<<(ostream&, GObjList<TT>&);

private:
// Private methods:

protected:

// Private data:
        GINT              nid;
        GINT              num;
        GBOOL             doRenumber;
        ObjLinkElem       *pStart;
        ObjLinkElem       *pCurr;
        ObjLinkElem       *pEnd;

};
#  if defined(_LINUX) || defined(_AIX)
template class GObjList<VectorOp>;
template class GObjList<GFieldGroup>;
template class GObjList<GLLBasis>;
template class GObjList<GLBasis>;
ostream &operator <<(ostream&, const GObjList<GFieldGroup>&);
# endif
#endif

