//************************************************************************************//
// Module       : gpobjbuffer.hpp
// Date         : 7/9/01 (DLR)
// Copyright    : 2001-2006 Copyright University Corporation for Atmospheric
//                Research
// Description  : Encapsulates the methods and data associated with
//                a buffer template object holding GASpAR object pointers
// Derived From : none.
// Modifications:
//************************************************************************************//
#if !defined(GPOBJBUFFER_HPP)
#define GPOBJBUFFER_HPP

#include "gtypes.h"
#include <iostream.h>
#include <stdlib.h>
#include "gllbasis.hpp"
#include "glbasis.hpp"


#if !defined(pGLLBuffer)
#  define pGLLBuffer  GpObjBuffer<GLLBasis>
#endif

#if !defined(pGLBuffer)
#  define pGLBuffer  GpObjBuffer<GLBasis>
#endif


template<class TBUFF> class GpObjBuffer
{


private:

// Private methods:
        void              DeleteDynamic();

// Private data:
        GINT               n;
        TBUFF             **data;


public:
                           GpObjBuffer();
                           GpObjBuffer(GINT  size);
                           GpObjBuffer(const GpObjBuffer &);
//virtual                 ~GpObjBuffer();
                          ~GpObjBuffer();


         void              operator=(GpObjBuffer<TBUFF> &);
         void              operator=(TBUFF *m);
inline    TBUFF            *&operator()(const GINT  i) { 
                            if ( i >= n || i < 0 ) {
                              cout << "GpObjBuffer<T>::(): access error: index=" << i << "; max=" <<  n << endl;
                              exit(1);
                             }
                            return data[i]; }
inline    TBUFF            *&operator[](const GINT  i) const {
                            if ( i >= n || i < 0 ) {
                              cout << "GpObjBuffer<T>::[]: access error: index=" << i << "; max=" <<  n << endl;
                              exit(1);
                             }
                            return data[i]; } 
#if 0
         friend ostream&   operator<<(ostream &, const GpObjBuffer<TBUFF> &);
#else
         friend ostream&   operator<<(ostream &, GpObjBuffer<GLLBasis> &);
         friend ostream&   operator<<(ostream &, GpObjBuffer<GLBasis>  &);
//       friend ostream&   operator<<(ostream &, GpObjBuffer<void>  &);
#endif
                   
         GINT              dim() const;
         TBUFF           **Data();
         GBOOL             Resize(GINT  order);
         GBOOL             contains(TBUFF *imember, GINT  &index);
         GBOOL             contains(TBUFF *imember, GINT  istart, GINT  num, GINT  &index);
         void              GetSection(GpObjBuffer<TBUFF> &section, GINT  *ilist, GINT  nlist);
         GpObjBuffer<TBUFF> &GetSection(GINT  *ilist, GINT  nlist);


};
#if defined(_LINUX) || defined(_AIX)
template class GpObjBuffer<GLLBasis>;
ostream &operator <<(ostream&, const GpObjBuffer<GLLBasis>&);
template class GpObjBuffer<GLBasis>;
ostream &operator <<(ostream&, const GpObjBuffer<GLBasis>&);
//template class GpObjBuffer<void>;
//ostream &operator <<(ostream&, const GpObjBuffer<void>&);
#endif
#endif
